/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.portaltransparencia.admportal.service.PortalAdminOxyArquivoService;
import br.com.elotech.portaltransparencia.contabportal.domain.ArquivoContab;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalOrganograma;
import br.com.elotech.portaltransparencia.contabportal.repository.PortalOrganogramaRepository;
import java.io.Serializable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OrganogramaAdminService
extends CrudService<PortalOrganograma, Long> {
    private final PortalAdminOxyArquivoService arquivoService;
    private final PortalOrganogramaRepository portalOrganogramaRepository;

    public OrganogramaAdminService(PortalAdminOxyArquivoService arquivoService, PortalOrganogramaRepository portalOrganogramaRepository) {
        this.arquivoService = arquivoService;
        this.portalOrganogramaRepository = portalOrganogramaRepository;
    }

    @Transactional
    public PortalOrganograma adicionarArquivo(Long id, MultipartFile file) {
        PortalOrganograma organograma = (PortalOrganograma)this.findOne((Serializable)id);
        organograma.setArquivo(this.arquivoService.adicionarArquivo(file));
        return (PortalOrganograma)this.save((EloEntity)organograma, null);
    }

    @Transactional
    public PortalOrganograma removerArquivo(Long id) {
        PortalOrganograma organograma = (PortalOrganograma)this.findOne((Serializable)id);
        ArquivoContab arquivo = organograma.getArquivo();
        organograma.setArquivo(null);
        this.arquivoService.deletarArquivo(arquivo);
        return organograma;
    }

    public Page<PortalOrganograma> findByAllByEntidade(Long entidade, Pageable pageable) {
        return this.portalOrganogramaRepository.findAllByEntidadeOrderByOrdem(entidade, pageable);
    }
}

