/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.service;

import br.com.elotech.multitenant.client.TenantClient;
import br.com.elotech.multitenant.domain.Tenant;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.admportal.service.RunInAnotherTransactionComponent;
import br.com.elotech.portaltransparencia.aiseportal.service.ServidorService;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroPK;
import br.com.elotech.portaltransparencia.web.rest.params.PermutaParams;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class CacheService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheService.class);
    private final Optional<TenantClient> tenantClient;
    private final ServidorService servidorService;
    private final PortalParametroService portalParametroService;
    private final RunInAnotherTransactionComponent runInAnotherTransactionComponent;

    @CacheEvict(value={"servidores_webservice", "estagiarios_webservice", "permutas_webservice"}, allEntries=true)
    public void clearCache() {
    }

    @Async
    public void reloadCache() {
        log.info("Iniciando reload de cache ass\u00edncrono");
        this.getTenantClient().getAllTenants().forEach(tenant -> {
            if (!tenant.getAtivo().booleanValue()) {
                log.debug("Ignorando tenant inativo: {}", (Object)tenant.getId());
                return;
            }
            TenantContextHolder.setTenant((Tenant)tenant);
            try {
                this.runInAnotherTransactionComponent.run(() -> this.reloadCache(tenant));
                log.debug("Finalizou carregamento dos cache para o tenant {}", (Object)tenant.getId());
            }
            catch (Exception e) {
                log.error("Erro ao carregar cache para o tenant {}", (Object)tenant.getId(), (Object)e);
            }
            finally {
                TenantContextHolder.resetTenant();
            }
        });
        log.info("Reload de cache ass\u00edncrono conclu\u00eddo");
    }

    private TenantClient getTenantClient() {
        return (TenantClient)this.tenantClient.orElseThrow(() -> new IllegalStateException("N\u00e3o \u00e9 poss\u00edvel reiniciar os caches sem uma inst\u00e2ncia do TenantClient"));
    }

    private void reloadCache(Tenant tenant) {
        List entidades = this.getAllEntidadesExerciciosParametroWebserviceAtivo();
        if (entidades.isEmpty()) {
            log.debug("Ignorando tenant que n\u00e3o utiliza webservice: {}", (Object)tenant.getId());
            return;
        }
        entidades.forEach(parametro -> {
            log.debug("Iniciando carregamento dos cache para o tenant {}, entidade {}, exercicio {}", new Object[]{tenant.getId(), parametro.getEntidade(), parametro.getExercicio()});
            this.servidorService.loadServidor(ServidorParams.builder().entidade(parametro.getEntidade()).exercicio(parametro.getExercicio()).build());
            log.debug("Carregou servidores do tenant {}, entidade {}, exercicio {}", new Object[]{tenant.getId(), parametro.getEntidade(), parametro.getExercicio()});
            this.servidorService.loadEstagiarios(ServidorParams.builder().entidade(parametro.getEntidade()).exercicio(parametro.getExercicio()).build(), Pageable.unpaged());
            log.debug("Carregou estagi\u00e1rios do tenant {}, entidade {}, exercicio {}", new Object[]{tenant.getId(), parametro.getEntidade(), parametro.getExercicio()});
            this.servidorService.loadPermutas(PermutaParams.builder().entidade(parametro.getEntidade()).exercicio(parametro.getExercicio()).build(), Pageable.unpaged());
            log.debug("Carregou permutas do tenant {}, entidade {}, exercicio {}", new Object[]{tenant.getId(), parametro.getEntidade(), parametro.getExercicio()});
        });
    }

    private List<PortalParametroPK> getAllEntidadesExerciciosParametroWebserviceAtivo() {
        return this.portalParametroService.findAllByParametroAndValor(Parametros.PARAM_WEBSERVICE_MARINGA, "1").stream().map(PortalParametroContabil::getId).toList();
    }

    @Generated
    public CacheService(Optional<TenantClient> tenantClient, ServidorService servidorService, PortalParametroService portalParametroService, RunInAnotherTransactionComponent runInAnotherTransactionComponent) {
        this.tenantClient = tenantClient;
        this.servidorService = servidorService;
        this.portalParametroService = portalParametroService;
        this.runInAnotherTransactionComponent = runInAnotherTransactionComponent;
    }
}

