/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.resource;

import br.com.elotech.console.client.UsuarioClient;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.console.dto.RolesUsuarioDTO;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.domain.dto.PortalConfigDTO;
import br.com.elotech.portaltransparencia.admportal.service.ActiveProfile;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.admportal.utils.SecurityUtils;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/admin/config"})
@RestController
public class PortalConfigResource {
    private final Environment environment;
    private final PortalParametroService parametroService;
    private final EntidadeContabilidadeService entidadeContabilidadeService;
    private final Optional<UsuarioClient> usuarioClient;

    @GetMapping
    public ResponseEntity<PortalConfigDTO> getPortalConfig() {
        PortalConfigDTO config = new PortalConfigDTO();
        Boolean isKeyCloak = ActiveProfile.isProfileActive((Environment)this.environment, (String)"keycloak") != false || ActiveProfile.isProfileActive((Environment)this.environment, (String)"cloud") != false;
        config.setIsIntegradoKeyCloak(isKeyCloak);
        config.setIsOnpremise(ActiveProfile.isProfileActive((Environment)this.environment, (String)"onpremise"));
        return ResponseEntity.ok((Object)config);
    }

    @GetMapping(value={"/possui-acesso"})
    public ResponseEntity<Boolean> possuiAcessoAdministrador() {
        String portalParametroValor = this.parametroService.getPortalParametroValor(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_ADMINS_SISTEMA);
        boolean isAdministradorOnPremise = Arrays.stream(Optional.ofNullable(portalParametroValor).orElse("").split(";")).anyMatch(email -> email.equals(SecurityUtils.getEmail()));
        boolean isKeycloakPortalAdmin = false;
        if (this.usuarioClient.isPresent()) {
            UUID userId = SecurityUtils.getUserId();
            Optional entidade = this.entidadeContabilidadeService.getEntidadePrincipal();
            if (entidade.isPresent()) {
                RolesUsuarioDTO roles = ((UsuarioClient)this.usuarioClient.get()).findAllRolesByUsuarioAndEntidadeAndModulo(userId, ((Entidade)entidade.get()).getEntidadeConsole(), Modulo.OXY_PORTAL_TRANSPARENCIA);
                isKeycloakPortalAdmin = roles.getClientRoles().stream().anyMatch(role -> role.getName().equalsIgnoreCase("administrador"));
            }
        }
        return ResponseEntity.ok((Object)(isAdministradorOnPremise || isKeycloakPortalAdmin ? 1 : 0));
    }

    @Generated
    public PortalConfigResource(Environment environment, PortalParametroService parametroService, EntidadeContabilidadeService entidadeContabilidadeService, Optional<UsuarioClient> usuarioClient) {
        this.environment = environment;
        this.parametroService = parametroService;
        this.entidadeContabilidadeService = entidadeContabilidadeService;
        this.usuarioClient = usuarioClient;
    }
}

