/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.resource;

import br.com.elotech.portaltransparencia.admportal.domain.NotaExplicativa;
import br.com.elotech.portaltransparencia.admportal.domain.Rota;
import br.com.elotech.portaltransparencia.admportal.domain.dto.NotaExplicativaDTO;
import br.com.elotech.portaltransparencia.admportal.domain.dto.converter.NotaExplicativaConverter;
import br.com.elotech.portaltransparencia.admportal.repository.RotaRepository;
import br.com.elotech.portaltransparencia.admportal.resource.params.NotaExplicativaParams;
import br.com.elotech.portaltransparencia.admportal.service.NotaExplicativaService;
import br.com.elotech.portaltransparencia.admportal.service.S3Service;
import br.com.elotech.portaltransparencia.contabportal.service.ConfiguracaoService;
import br.com.elotech.portaltransparencia.enums.TipoNotaExplicativa;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/notas-explicativa", "/admin/notas-explicativa"})
public class NotaExplicativaResource {
    private final NotaExplicativaService notaExplicativaService;
    private final RotaRepository rotaRepository;
    private final ConfiguracaoService configuracaoService;
    private final S3Service s3Service;

    @GetMapping(value={"/list"})
    public ResponseEntity<List<NotaExplicativa>> findNotaExplicativa(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio) {
        return ResponseEntity.ok((Object)this.notaExplicativaService.findNotaExplicativaAndExercicio(entidade, exercicio));
    }

    @GetMapping(params={"entidade"})
    public ResponseEntity<Page<NotaExplicativaDTO>> findNotaExplicativaPaginado(NotaExplicativaParams params, Pageable pageable) {
        Page notasPage = this.notaExplicativaService.findNotaExplicativa(params, pageable);
        return ResponseEntity.ok((Object)notasPage.map(n -> NotaExplicativaConverter.toDTO((NotaExplicativa)n, (Rota)this.getRota(n.getPath()))));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<NotaExplicativaDTO> findOne(@PathVariable(value="id") Long id) {
        NotaExplicativa nota = (NotaExplicativa)this.notaExplicativaService.findOne((Serializable)id);
        if (Objects.isNull(nota)) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)NotaExplicativaConverter.toDTO((NotaExplicativa)nota, (Rota)this.getRota(nota.getPath())));
    }

    @PostMapping
    public ResponseEntity<NotaExplicativa> save(@RequestBody NotaExplicativaDTO notaDTO) throws URISyntaxException {
        return ResponseEntity.created((URI)new URI("")).body((Object)this.notaExplicativaService.save(NotaExplicativaConverter.toEntity((NotaExplicativaDTO)notaDTO)));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<NotaExplicativaDTO> update(@RequestBody NotaExplicativaDTO nota, @PathVariable(value="id") Long id) {
        NotaExplicativa updated = this.notaExplicativaService.update(NotaExplicativaConverter.toEntity((NotaExplicativaDTO)nota));
        return ResponseEntity.ok((Object)NotaExplicativaConverter.toDTO((NotaExplicativa)updated, (Rota)this.getRota(updated.getPath())));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> remove(@PathVariable(value="id") Long id) {
        NotaExplicativa nota = (NotaExplicativa)this.notaExplicativaService.findOne((Serializable)id);
        if (Objects.isNull(nota)) {
            return ResponseEntity.notFound().build();
        }
        this.notaExplicativaService.delete(nota);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/publication-types"})
    private ResponseEntity<TipoNotaExplicativa[]> getPublicationTypes() {
        return ResponseEntity.ok().body((Object)TipoNotaExplicativa.values());
    }

    @PostMapping(value={"/save-image"})
    public ResponseEntity<?> saveImagem(@RequestParam(value="file") MultipartFile file, @RequestParam(value="id") Long id) {
        if (file.isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        try {
            NotaExplicativa nota = (NotaExplicativa)this.notaExplicativaService.findOne((Serializable)id);
            nota.setImgPath(this.s3Service.uploadToS3(file, this.configuracaoService.getConfiguracao()));
            this.notaExplicativaService.update(nota);
        }
        catch (IOException | InvalidPathException e) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        return ResponseEntity.ok().build();
    }

    private Rota getRota(String rota) {
        return this.rotaRepository.findFirstByRotaIgnoreCase(rota);
    }

    @Generated
    public NotaExplicativaResource(NotaExplicativaService notaExplicativaService, RotaRepository rotaRepository, ConfiguracaoService configuracaoService, S3Service s3Service) {
        this.notaExplicativaService = notaExplicativaService;
        this.rotaRepository = rotaRepository;
        this.configuracaoService = configuracaoService;
        this.s3Service = s3Service;
    }
}

