SELECT
    tc.Descricao as DescricaoTipoCadastro,
    cg.Codigo as CadastroGeral,
    cg.Loteamento as Setor,
    cg.Quadra,
    cg.Lote,
    g.Descricao as DescricaoDivida,
    sp.descricao as situacaoLegal,
    case    
     when p.estornado is not null and p.estornado = 'N' then 'Protestado'
     else 'Sem Protesto'
     end as condicao,
     case when (coalesce( g.GUIATRIBUTARIA, 'N' ) = 'S') then 'Tributária' else 'Não Tributária' end as guiaTributaria,
    sum(vp.valor) as Valor
FROM ${db.smt.schema}.CadastroGeral cg
    JOIN ${db.smt.schema}.CGCM c
       ON c.codigo = cg.CodigoCGCM
    JOIN ${db.smt.schema}.tipocadastro tc
       ON tc.Codigo = cg.Tipo
    JOIN ${db.smt.schema}.valoresparcelas vp
        ON vp.TipoCadastro = cg.Tipo
        AND vp.CodigoImovel = cg.Codigo
    JOIN ${db.smt.schema}.guiasrecolhimento g
        ON vp.CodigoDivida = g.Codigo
    LEFT OUTER JOIN ${db.smt.schema}.situacaoparcela sp
        ON sp.situacaoparcela = vp.situacao
    LEFT OUTER JOIN ${db.smt.schema}.protestoparcela pp
        ON pp.idvaloresparcelas = vp.IDVALORESPARCELAS
    LEFT OUTER JOIN ${db.smt.schema}.protesto p
        ON p.idprotesto = pp.idprotesto
WHERE c.nome = :nome
	AND c.codigo IN (:idContribuinte)
	AND vp.Situacao in (1,2)
$[FILTRO]
GROUP BY tc.Descricao, cg.Codigo, cg.Loteamento, cg.Quadra, cg.Lote, g.Descricao, sp.descricao, p.estornado,
         g.guiaTributaria
ORDER BY tc.Descricao, cg.Codigo, cg.Loteamento, cg.Quadra, cg.Lote
