SELECT E.EXERCICIO,
       E.MES,
       COUNT(A.TIPO) AS PEDIDOS,
       SUM(CASE WHEN A.STATUS = 'A'
                 AND A.SITUACAO <> CAST(COALESCE(B.VALOR, '2') AS INTEGER)
                 AND A.SITUACAO <> CAST(COALESCE(C.VALOR, '2') AS INTEGER) THEN 1 ELSE 0 END) AS ATENDIDOS,
       SUM(CASE WHEN A.STATUS = 'A' AND A.SITUACAO = CAST(COALESCE(B.VALOR, '2') AS INTEGER) THEN 1 ELSE 0 END) AS CANCELADOS,
       SUM(CASE WHEN A.STATUS = 'A' AND A.SITUACAO = CAST(COALESCE(C.VALOR, '2') AS INTEGER) THEN 1 ELSE 0 END) AS INDEFERIDOS
  FROM ${db.protocolo.schema}.EXERCICIO_MES E
  LEFT OUTER JOIN ${db.protocolo.schema}.PROCESSOS A
    ON A.ENTIDADE = E.ENTIDADE
   AND A.ANO = E.EXERCICIO
   AND EXTRACT(MONTH FROM A.DATAPROCESSO) = E.MES
   AND A.USUARIOREG = 'e-SIC'
  LEFT OUTER JOIN ${db.protocolo.schema}.PARAMETROS B
    ON B.ENTIDADE = E.ENTIDADE
   AND B.EXERCICIO = E.EXERCICIO
   AND B.CODIGO = 91
   AND B.VALOR LIKE '_%'
  LEFT OUTER JOIN ${db.protocolo.schema}.PARAMETROS C
    ON C.ENTIDADE = E.ENTIDADE
   AND C.EXERCICIO = E.EXERCICIO
   AND C.CODIGO = 107
   AND C.VALOR LIKE '_%'
 WHERE 1=1 
$[FILTRO]
GROUP BY E.EXERCICIO, E.MES
ORDER BY E.EXERCICIO, E.MES


