SELECT A.ENTIDADE, 
       A.EXERCICIO, 
	   A.EMPENHO AS PRESTACAOCONTAS,
	   F.NOME, 
       A.DATA AS DATAPRESTACAO, 
       A.EMPENHO, 
       A.EXERCICIO AS EXERCICIOEMPENHO, 
       A.DATA AS DATAEMPENHO, 
       A.VALOR AS  VALOREMPENHO, 
       COALESCE((SELECT SUM(VALORPAGAMENTO -VALORESTPAGAMENTO)
                   FROM ${db.contabilidade.schema}.FICHAEMPENHO FE
                  WHERE FE.ENTIDADE  = A.ENTIDADE
                    AND FE.EXERCICIO = A.EXERCICIO
                    AND FE.EMPENHO   = A.EMPENHO),0) AS VALORPAGO,
       COALESCE((SELECT SUM(DOC.VALOR) 
                   FROM ${db.contabilidade.schema}.PRESTACAOCONTASDOCUMENTO DOC
                  WHERE A.ENTIDADE        = DOC.ENTIDADE
                    AND A.EXERCICIO       = DOC.EXERCICIO
                    AND A.EMPENHO         = DOC.PRESTACAOCONTAS
                    AND DOC.TIPODOCUMENTO <> 99),0) AS VALORDOCUMENTOS,
        0 AS VALORRESTITUIDOSUB, 
        0 AS VALORPRESTAR,
        CAST(' ' AS VARCHAR(10)) AS CARGO,
        CAST(' ' AS VARCHAR(10)) AS LOTACAO,
        CAST(' ' AS VARCHAR(10)) AS UNIDADEORCAMENTARIA,
		0 AS NOLIQUIDACAO,
		CAST(' ' AS VARCHAR(10)) AS MATRICULA,
        0 AS VALORRESTITUIDO, 	
        0 AS VALOREXCEDIDO,
        0 AS EMPENHOEXCEDIDO,
        0 AS EXERCICIOEMPENHOEXCEDIDO,
        0 AS RECEITAVALOR
  FROM ${db.contabilidade.schema}.EMPENHO A
  LEFT OUTER JOIN ${db.contabilidade.schema}.FORNECEDOR F
    ON A.FORNECEDOR = F.FORNECEDOR
 WHERE A.REEMBOLSO = 'S' AND A.EXERCICIO = :exercicio
   AND NOT EXISTS(SELECT 1
                    FROM ${db.contabilidade.schema}.PRESTACAOCONTAS PREST
                   WHERE PREST.ENTIDADE            = A.ENTIDADE
                     AND PREST.EXERCICIOEMPENHO    = A.EXERCICIO
                     AND PREST.EMPENHO             = A.EMPENHO
                     AND PREST.UNIDADEORCAMENTARIA = A.UNIDADEORCAMENTARIA)