SELECT TB2.*
FROM
(SELECT TB1.ENTIDADE, TB1.RECEITA, TB1.DESCRICAO,
        CAST(TB1.FONTERECURSO AS NUMERIC(15)) AS FONTERECURSO,
        CAST(TB1.FONTERECURSORATEIO AS NUMERIC(15)) AS FONTERECURSORATEIO,
        TB1.DESCRICAOFONTE,
    SUM(TB1.VALORORCADO) AS VALORORCADO,
    SUM(TB1.VALORORCADO) + SUM(TB1.VALORORCADOATUALIZADO) AS VALORATUALIZADO,
        SUM(TB1.VALORARRECADADO) AS VALORARRECADADO        
FROM
(SELECT RECEITA_FONTETCE.RECEITA,
        RECEITA.DESCRICAO,
        RECEITA.ENTIDADE,
        FONTERECURSO.FONTERECURSO AS FONTERECURSORATEIO,
        FONTERECURSO.DESCRICAO AS DESCRICAOFONTE,
        RECEITA_FONTETCE.PERCENTUAL, 
        RECEITA.FONTERECURSO,
        COALESCE(((COALESCE(RECEITA.VALORORCADO,0)/100) * COALESCE(RECEITA_FONTETCE.PERCENTUAL,0)),0) AS VALORORCADO,
             ((SELECT SUM(COALESCE(RECEITAMENSAL.VALORCORRECAOORCADO,0) + COALESCE(RECEITAMENSAL.VALORCORRECAO,0))                                                                                           
                     FROM ${db.contabilidade.schema}.RECEITAMENSAL RECEITAMENSAL
                     WHERE  RECEITAMENSAL.ENTIDADE              = RECEITA.ENTIDADE                                                                                                                                 
                     AND    RECEITAMENSAL.EXERCICIO                        = RECEITA.EXERCICIO                                                                                                                                
                     AND    RECEITAMENSAL.RECEITA                                = RECEITA.RECEITA                                                                                                                                  
                     AND    RECEITAMENSAL.FONTERECURSO                    = RECEITA.FONTERECURSO                                                                                                                             
                     AND    RECEITAMENSAL.IDTIPOOPERACAORECEITA = RECEITA.IDTIPOOPERACAORECEITA) /100) * COALESCE(RECEITA_FONTETCE.PERCENTUAL,0) AS VALORORCADOATUALIZADO,
           COALESCE((SELECT SUM(CASE WHEN RR.GRUPOEVENTO in (11,14) then RRI.VALOR else RRI.VALOR*-1 END) 
           FROM ${db.contabilidade.schema}.REALIZACAORECEITA RR
           JOIN ${db.contabilidade.schema}.REALIZACAORECEITAITEM RRI
           ON     RRI.ENTIDADE     = RR.ENTIDADE                                                
           AND    RRI.EXERCICIO    = RR.EXERCICIO                                               
           AND    RRI.LANCAMENTO   = RR.LANCAMENTO                                              
           WHERE  RR.ENTIDADE        = RECEITA.ENTIDADE                               
           AND       RR.EXERCICIO       = RECEITA.EXERCICIO                                        
           AND    RR.RECEITA         = RECEITA.RECEITA                                        
           AND    RR.FONTERECURSO = RECEITA.FONTERECURSO
           AND    RR.IDTIPOOPERACAORECEITA = RECEITA.IDTIPOOPERACAORECEITA
           AND    RR.DATA >= :dataInicial AND RR.DATA <= :dataFinal
           AND    RRI.FONTERECURSO   = FONTERECURSO.FONTERECURSO
           AND    RRI.IDTIPOOPERACAORECEITA = RECEITA.IDTIPOOPERACAORECEITA
           AND    ( COALESCE(RECEITA.COVID19,'N') = 'S' OR  COALESCE(RR.COVID19, 'N') = 'S')
   ),0) VALORARRECADADO
FROM ${db.contabilidade.schema}.RECEITA RECEITA
JOIN ${db.contabilidade.schema}.RECEITA_FONTETCE RECEITA_FONTETCE
    ON  RECEITA_FONTETCE.ENTIDADE                = RECEITA.ENTIDADE     
 AND RECEITA_FONTETCE.EXERCICIO             = RECEITA.EXERCICIO     
 AND RECEITA_FONTETCE.RECEITA               = RECEITA.RECEITA       
 AND RECEITA_FONTETCE.FONTERECURSO          = RECEITA.FONTERECURSO  
 AND RECEITA_FONTETCE.IDTIPOOPERACAORECEITA = RECEITA.IDTIPOOPERACAORECEITA
JOIN ${db.contabilidade.schema}.FONTERECURSO FONTERECURSO
ON  FONTERECURSO.FONTERECURSO = RECEITA_FONTETCE.VINCULOFONTERECURSO 
WHERE RECEITA.EXERCICIO           = :exercicio
  AND COALESCE(RECEITA.MOVSN,'N') = 'S'
  AND EXISTS (SELECT 1
                FROM ${db.contabilidade.schema}.REALIZACAORECEITA RRR
               WHERE RRR.ENTIDADE = RECEITA.ENTIDADE
                AND RRR.EXERCICIO = RECEITA.EXERCICIO
                AND RRR.RECEITA = RECEITA.RECEITA
                AND RRR.FONTERECURSO = RECEITA.FONTERECURSO
                AND RRR.IDTIPOOPERACAORECEITA = RECEITA.IDTIPOOPERACAORECEITA
                AND RRR.DATA >= :dataInicial AND RRR.DATA <= :dataFinal
                AND ( COALESCE(RECEITA.COVID19,'N') = 'S' OR  COALESCE(RRR.COVID19, 'N') = 'S'))
ORDER BY RECEITA,FONTERECURSO) TB1
GROUP BY TB1.ENTIDADE, TB1.RECEITA, TB1.DESCRICAO, TB1.FONTERECURSO, TB1.FONTERECURSORATEIO,  TB1.DESCRICAOFONTE) TB2
WHERE (TB2.VALORORCADO > 0 OR TB2.VALORATUALIZADO > 0 OR TB2.VALORARRECADADO > 0)