SELECT row_number() OVER (PARTITION BY XX.FONTERECURSO ORDER BY XX.FONTERECURSO, XX.DATA, XX.EMPENHO, XX.EXERCICIO) AS ORDEMFONTERECURSO, XX.*
  FROM (
SELECT DISTINCT
       FR.FONTERECURSO || ' - ' || FR.DESCRICAO AS FONTERECURSO,
       L.DATA,
       L.EXERCICIO AS EXERCICIOLIQUIDACAO,
       L.NOLIQUIDACAO,
       E.EMPENHO || '/' || E.EXERCICIO AS EMPENHOEXERCICIO,
       E.ENTIDADE,
       E.EXERCICIO,
       E.EMPENHO,
       E.UNIDADEORCAMENTARIA,
       TL.DESCRICAO AS TIPOLICITACAO,
       E.NOLICITACAO || '/' || E.ANOLICITACAO AS LICITACAO,
	   E.DATA AS DATAEMPENHO,
       CASE WHEN F.TIPOPESSOA = 'F' THEN '****' || SUBSTR(F.CNPJ, 5, 3) || '****' || ' - ' || (${db.contabilidade.schema}.BUSCARAZAOSOCIALFORNECEDOR(F.FORNECEDOR, L.DATA)) 
            ELSE SUBSTR(F.CNPJ,1,2) || '.' || SUBSTR(F.CNPJ,3,3) || '.' || SUBSTR(F.CNPJ,6,3) || '/' || SUBSTR(F.CNPJ,9,4) || '-' || SUBSTR(F.CNPJ,13,2) || ' - ' || (${db.contabilidade.schema}.BUSCARAZAOSOCIALFORNECEDOR(F.FORNECEDOR, L.DATA))
       END AS FORNECEDOR,
       L.VALOR AS VALOR,
       (L.VALOR - L.VALORRETENCOES -
       (SELECT COALESCE(SUM(EL.VALOR), 0)
          FROM ${db.contabilidade.schema}.ESTORNOLIQUIDACAO EL
         WHERE EL.ENTIDADE = L.ENTIDADE
           AND EL.EXERCICIOLIQ = L.EXERCICIO
           AND EL.TIPODOCORIGEM = L.TIPODOCORIGEM
           AND EL.ANODOCORIGEM = L.ANODOCORIGEM
           AND EL.NODOCORIGEM = L.NODOCORIGEM
           AND EL.UNIDADEDOCORIGEM = L.UNIDADEDOCORIGEM
           AND EL.NOLIQUIDACAO = L.NOLIQUIDACAO) -
       (SELECT COALESCE(SUM(OPL.VALOR), 0)
          FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OPL
          JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO OP
            ON OP.ENTIDADE  = OPL.ENTIDADE
           AND OP.EXERCICIO = OPL.EXERCICIO
           AND OP.NOORDEM   = OPL.NOORDEM
           AND OP.CANCELADO = 'P'
         WHERE OPL.ENTIDADE = L.ENTIDADE
           AND OPL.EXERCICIOLIQ  = L.EXERCICIO
           AND OPL.TIPODOCORIGEM = L.TIPODOCORIGEM
           AND OPL.ANODOCORIGEM  = L.ANODOCORIGEM
           AND OPL.NODOCORIGEM   = L.NODOCORIGEM
           AND OPL.UNIDADEDOCORIGEM = L.UNIDADEDOCORIGEM
           AND OPL.NOLIQUIDACAO = L.NOLIQUIDACAO) -
       (SELECT COALESCE(SUM(R.VALOR), 0)
          FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_RETENCAO R
          JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO OP
            ON OP.ENTIDADE  = R.ENTIDADE
           AND OP.EXERCICIO = R.EXERCICIO
           AND OP.NOORDEM   = R.NOORDEM
           AND OP.CANCELADO = 'P'
         WHERE R.ENTIDADE   = L.ENTIDADE
           AND R.EXERCICIOLIQ  = L.EXERCICIO
           AND R.TIPODOCORIGEM = L.TIPODOCORIGEM
           AND R.ANODOCORIGEM  = L.ANODOCORIGEM
           AND R.NODOCORIGEM   = L.NODOCORIGEM
           AND R.UNIDADEDOCORIGEM = L.UNIDADEDOCORIGEM
           AND R.NOLIQUIDACAO  = L.NOLIQUIDACAO)) AS SALDO,
           CASE WHEN EXTRACT(YEAR FROM L.DATAVENCIMENTO) <> 1899 THEN L.DATAVENCIMENTO ELSE NULL END AS C_DATAVENCIMENTO,
           CASE WHEN EXTRACT(YEAR FROM O.VENCIMENTO)     <> 1899 THEN O.VENCIMENTO     ELSE NULL END AS C_VENCIMENTO
  FROM ${db.contabilidade.schema}.LIQUIDACAO L
  LEFT JOIN ${db.contabilidade.schema}.EMPENHO E
    ON E.ENTIDADE  = L.ENTIDADE
   AND E.EXERCICIO = L.ANODOCORIGEM
   AND E.EMPENHO   = L.NODOCORIGEM
   AND E.UNIDADEORCAMENTARIA = L.UNIDADEDOCORIGEM
   AND E.CONTABILIZADO = 'S'
   AND COALESCE(E.EXIBICAOBASICA,'N') = 'N'
  LEFT OUTER JOIN ${db.contabilidade.schema}.DESPESA DESP
    ON E.ENTIDADE = DESP.ENTIDADE
   AND E.EXERCICIO = DESP.EXERCICIO
   AND E.PROGRAMATICA = DESP.PROGRAMATICA
   AND E.FONTERECURSO = DESP.FONTERECURSO   
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA ORG
    ON DESP.MODELODESPESA = ORG.MODELODESPESA
   AND ORG.TIPO = 'P'
   AND ORG.ORDEM = 1   
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA UNID
    ON DESP.MODELODESPESA = UNID.MODELODESPESA
   AND UNID.TIPO = 'C'
   AND UNID.ORDEM = 2  
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA FUNCAO
    ON DESP.MODELODESPESA = FUNCAO.MODELODESPESA
   AND FUNCAO.TIPO = 'P'
   AND FUNCAO.ORDEM = 3
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA SUBFUNCAO
    ON DESP.MODELODESPESA = SUBFUNCAO.MODELODESPESA
   AND SUBFUNCAO.TIPO = 'P'
   AND SUBFUNCAO.ORDEM = 4
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA PROG
    ON DESP.MODELODESPESA = PROG.MODELODESPESA
   AND PROG.TIPO = 'P'
   AND PROG.ORDEM = 5
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA PROJ
    ON DESP.MODELODESPESA = PROJ.MODELODESPESA
   AND PROJ.TIPO = 'P'
   AND PROJ.ORDEM = 6
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA ELEM
    ON DESP.MODELODESPESA = ELEM.MODELODESPESA
   AND ELEM.TIPO = 'C'
   AND ELEM.ORDEM = 7   
  LEFT JOIN ${db.contabilidade.schema}.FONTERECURSO FR
    ON E.FONTERECURSO = FR.FONTERECURSO
  LEFT JOIN ${db.contabilidade.schema}.FONTERECURSOPADRAO FRP
    ON FR.CODIGOFONTEPADRAO = FRP.CODIGO    
  LEFT JOIN ${db.contabilidade.schema}.TIPOSLICITACAO TL
    ON E.TIPOLICITACAO = TL.TIPOLICITACAO
  LEFT JOIN ${db.contabilidade.schema}.FORNECEDOR F
    ON E.FORNECEDOR = F.FORNECEDOR
  LEFT JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OL
    ON OL.ENTIDADE      = L.ENTIDADE
   AND OL.EXERCICIOLIQ  = L.EXERCICIO
   AND OL.TIPODOCORIGEM = L.TIPODOCORIGEM
   AND OL.ANODOCORIGEM  = L.ANODOCORIGEM
   AND OL.NODOCORIGEM   = L.NODOCORIGEM
   AND OL.UNIDADEDOCORIGEM = L.UNIDADEDOCORIGEM
   AND OL.NOLIQUIDACAO  = L.NOLIQUIDACAO
  LEFT JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO O
    ON O.ENTIDADE  = OL.ENTIDADE
   AND O.EXERCICIO = OL.EXERCICIO
   AND O.NOORDEM   = OL.NOORDEM
  $[FILTRO]
       ) XX 
  $[WHERE]
  (((XX.EXERCICIOLIQUIDACAO <= 2013) AND 
        (NOT EXISTS (SELECT C.EMPENHO
                       FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                      WHERE C.ENTIDADE   = XX.ENTIDADE
                        AND C.EXERCICIO  = XX.EXERCICIO
                        AND C.EMPENHO    = XX.EMPENHO
                        AND C.UNIDADEORCAMENTARIA = XX.UNIDADEORCAMENTARIA
                        AND C.FLAGAPROCESSAR = 'N'))) OR (XX.EXERCICIOLIQUIDACAO > 2013))
   AND EXISTS (SELECT X.ENTIDADE, X.EXERCICIO, X.EMPENHO, X.UNIDADEORCAMENTARIA
                 FROM (SELECT E.ENTIDADE,
                              E.EXERCICIO,
                              E.EMPENHO,
                              E.UNIDADEORCAMENTARIA,
                              SUM(FE.VALOR) AS EMPENHADO,
                              SUM(FE.VALORANULACOES - FE.VALORESTANULACOES) AS ANULADO,
                              SUM(FE.VALORRETENCOES) AS RETIDO,
                              SUM(FE.VALORPAGAMENTO - FE.VALORESTPAGAMENTO) AS PAGO
                         FROM ${db.contabilidade.schema}.EMPENHO E
                         LEFT OUTER JOIN ${db.contabilidade.schema}.FICHAEMPENHO FE
                           ON E.ENTIDADE  = FE.ENTIDADE
                          AND E.EXERCICIO = FE.EXERCICIO
                          AND E.EMPENHO   = FE.EMPENHO
                          AND E.UNIDADEORCAMENTARIA = FE.UNIDADEORCAMENTARIA
                        WHERE E.CONTABILIZADO = 'S'
                        GROUP BY E.ENTIDADE, E.EXERCICIO, E.EMPENHO, E.UNIDADEORCAMENTARIA) X
                WHERE X.ENTIDADE  = XX.ENTIDADE
                  AND X.EXERCICIO = XX.EXERCICIO
                  AND X.EMPENHO   = XX.EMPENHO
                  AND X.UNIDADEORCAMENTARIA = XX.UNIDADEORCAMENTARIA)             
