SELECT L.ENTIDADE,
       L.ANODOCORIGEM AS EXERCICIO,
       L.NODOCORIGEM AS EMPENHO,
       L.UNIDADEDOCORIGEM AS UNIDADEORCAMENTARIA,
       L.EXERCICIO AS EXERCICIOLIQUIDACAO,
       L.NOLIQUIDACAO,
       L.DATACONTABILIZADO AS DATA,
       SUM(L.VALOR) AS VALOR,
       SUM(CASE WHEN L.DATAESTCONTABILIZADO IS NOT NULL THEN L.VALOR ELSE 0 END) AS VALORESTORNADO,
       CASE WHEN TX.CODIGO = 17 
         THEN '[F] - Pensão Alimentícia'
         ELSE COALESCE(CC.DESCRICAO, COALESCE(R.DESCRICAO,P.DESCRICAO)) 
       END AS DESCRICAO
  FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO L
  LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO E
    ON L.ENTIDADE = E.ENTIDADE
   AND L.ANODOCORIGEM = E.EXERCICIO
   AND L.NODOCORIGEM = E.EMPENHO
   AND L.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA
  LEFT OUTER JOIN ${db.contabilidade.schema}.CONTACORRENTE CC
    ON L.ENTIDADE = CC.ENTIDADE
   AND L.IDCONTACORRENTE = CC.IDCONTACORRENTE 
  LEFT OUTER JOIN ${db.contabilidade.schema}.PLANO P
    ON L.ENTIDADE = P.ENTIDADE
   AND L.EXERCICIO = P.EXERCICIO 
   AND L.CONTACREDITO = P.CONTA
  LEFT OUTER JOIN ${db.contabilidade.schema}.RECEITA R
    ON L.ENTIDADE = R.ENTIDADE
   AND L.EXERCICIO = R.EXERCICIO
   AND L.RECEITA = R.RECEITA
   AND L.FONTERECURSO = R.FONTERECURSO 
   AND L.IDTIPOOPERACAORECEITA = R.IDTIPOOPERACAORECEITA
  LEFT JOIN ${db.contabilidade.schema}.CADASTROEXTRA CX
    ON CX.ID = CC.IDCADASTROEXTRA
   AND CX.ENTIDADE = CC.ENTIDADE
  LEFT JOIN ${db.contabilidade.schema}.TIPOEXTRAORCAMENTARIO TX
    ON TX.ID = CX.IDTIPOEXTRAORCAMENTARIO