SELECT E.ENTIDADE,
       E.EXERCICIO,
       E.EMPENHO,
       CASE WHEN E.TIPO = '1' THEN 'Ordinário'
         WHEN E.TIPO = '2' THEN 'Global'
         WHEN E.TIPO = '3' THEN 'Estimativo'
		 WHEN E.TIPO = '4' THEN 'Ordinário - (COVID-19)'
		 WHEN E.TIPO = '5' THEN 'Global - (COVID-19)'
		 WHEN E.TIPO = '6' THEN 'Estimativo - (COVID-19)'
       END AS ESPECIE,
       E.DATA,
       E.DATAENTREGA,
       E.FORNECEDOR,
       F.NOME,
       CASE WHEN F.TIPOPESSOA = 'F' THEN '****' || SUBSTR(F.CNPJ, 5, 3) || '****'
		    ELSE SUBSTR(F.CNPJ,1,2) || '.' || SUBSTR(F.CNPJ,3,3) || '.' || SUBSTR(F.CNPJ,6,3) || '/' || SUBSTR(F.CNPJ,9,4) || '-' || SUBSTR(F.CNPJ,13,2)
	   END AS CNPJ,
       F.ENDERECO,
       F.CEP,
       F.CIDADE,
       F.UF,
	   F.BAIRRO,
       F.EMAIL,
       CAST(COALESCE(F.DDD,'')||(CASE WHEN F.DDD IS NULL THEN '' ELSE '-' END)|| F.TEL AS VARCHAR(25)) AS NUMEROTELEFONE,
       F.TIPOPESSOA AS TIPOFORNECEDOR,
       E.DESCRICAODESPESA,
       E.HISTORICONAD AS HISTORICO,
       E.TIPOLICITACAO,
	   LICAPIC.COMPRAS AS TIPOLICITACAOCOMPRAS,
       LIC.DESCRICAO AS MODALIDADE,
       E.NOLICITACAO NOLICITACAO,
       CASE WHEN E.ANOLICITACAO > 0 THEN E.ANOLICITACAO ELSE NULL END AS ANOLICITACAO,
       E.NOPROCESSO,
       CASE WHEN E.ANOPROCESSO > 0 THEN E.ANOPROCESSO ELSE NULL END AS ANOPROCESSO,
       E.IDCONVENIO,
       CC.NRCONVENIO,
       CC.NRANOCONVENIO,
       (SELECT SUM(FICHA.VALOR) FROM ${db.contabilidade.schema}.FICHAEMPENHO FICHA
        WHERE FICHA.ENTIDADE = E.ENTIDADE
        AND FICHA.EXERCICIO = E.EXERCICIO
        AND FICHA.EMPENHO = E.EMPENHO
        AND FICHA.UNIDADEORCAMENTARIA = E.UNIDADEORCAMENTARIA) AS VALOR,
       (SELECT SUM(FICHA.VALORANULACOES - FICHA.VALORESTANULACOES) FROM ${db.contabilidade.schema}.FICHAEMPENHO FICHA
        WHERE FICHA.ENTIDADE = E.ENTIDADE
        AND FICHA.EXERCICIO = E.EXERCICIO
        AND FICHA.EMPENHO = E.EMPENHO
        AND FICHA.UNIDADEORCAMENTARIA = E.UNIDADEORCAMENTARIA)  AS VALORANULADO,
       (SELECT SUM(FICHA.VALORLIQUIDACOES - FICHA.VALORESTLIQUIDACOES) FROM ${db.contabilidade.schema}.FICHAEMPENHO FICHA
        WHERE FICHA.ENTIDADE = E.ENTIDADE
        AND FICHA.EXERCICIO = E.EXERCICIO
        AND FICHA.EMPENHO = E.EMPENHO
        AND FICHA.UNIDADEORCAMENTARIA = E.UNIDADEORCAMENTARIA) AS VALORLIQUIDADO,
       (SELECT SUM(FICHA.VALORRETENCOES) FROM ${db.contabilidade.schema}.FICHAEMPENHO FICHA
        WHERE FICHA.ENTIDADE = E.ENTIDADE
        AND FICHA.EXERCICIO = E.EXERCICIO
        AND FICHA.EMPENHO = E.EMPENHO
        AND FICHA.UNIDADEORCAMENTARIA = E.UNIDADEORCAMENTARIA) AS VALORRETIDO,
       (SELECT SUM(FICHA.VALORPAGAMENTO - FICHA.VALORESTPAGAMENTO) FROM ${db.contabilidade.schema}.FICHAEMPENHO FICHA
        WHERE FICHA.ENTIDADE = E.ENTIDADE
        AND FICHA.EXERCICIO = E.EXERCICIO
        AND FICHA.EMPENHO = E.EMPENHO
        AND FICHA.UNIDADEORCAMENTARIA = E.UNIDADEORCAMENTARIA) AS VALORPAGO, 
       (SELECT SUM(FICHA.VALOR - FICHA.VALORANULACOES + FICHA.VALORESTANULACOES - FICHA.VALORRETENCOES - FICHA.VALORPAGAMENTO + FICHA.VALORESTPAGAMENTO)
         FROM ${db.contabilidade.schema}.FICHAEMPENHO FICHA
        WHERE FICHA.ENTIDADE = E.ENTIDADE
        AND FICHA.EXERCICIO = E.EXERCICIO
        AND FICHA.EMPENHO = E.EMPENHO
        AND FICHA.UNIDADEORCAMENTARIA = E.UNIDADEORCAMENTARIA) AS VALORAPAGAR,
       DESP.PROGRAMATICA,
       SUBSTR(DESP.PROGRAMATICA,ORG.POSICAO,ORG.TAMANHO) AS ORGAO,
       (SELECT PARAM.DESCRICAO FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA PARAM
          WHERE PARAM.ENTIDADE = DESP.ENTIDADE
         AND PARAM.EXERCICIO = DESP.EXERCICIO
         AND PARAM.MODELODESPESA = DESP.MODELODESPESA
         AND PARAM.TIPO = ORG.TIPO
         AND PARAM.ORDEM = ORG.ORDEM
         AND PARAM.CODIGO = SUBSTR(DESP.PROGRAMATICA,ORG.POSICAO,ORG.TAMANHO)) AS DESCRICAOORGAO,
       SUBSTR(DESP.PROGRAMATICA,UNID.POSICAO,UNID.TAMANHO) AS UNIDADE,
       (SELECT PARAM.DESCRICAO FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA PARAM
          WHERE PARAM.ENTIDADE = DESP.ENTIDADE
         AND PARAM.EXERCICIO = DESP.EXERCICIO
         AND PARAM.MODELODESPESA = DESP.MODELODESPESA
         AND PARAM.TIPO = UNID.TIPO
         AND PARAM.ORDEM = UNID.ORDEM
         AND PARAM.CODIGO = SUBSTR(DESP.PROGRAMATICA,UNID.POSICAO,UNID.TAMANHO)) AS DESCRICAOUNIDADE,
       SUBSTR(DESP.PROGRAMATICA,FUNCAO.POSICAO,FUNCAO.TAMANHO) AS FUNCAO,
       (SELECT PARAM.DESCRICAO FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA PARAM
          WHERE PARAM.ENTIDADE = DESP.ENTIDADE
         AND PARAM.EXERCICIO = DESP.EXERCICIO
         AND PARAM.MODELODESPESA = DESP.MODELODESPESA
         AND PARAM.TIPO = FUNCAO.TIPO
         AND PARAM.ORDEM = FUNCAO.ORDEM
         AND PARAM.CODIGO = SUBSTR(DESP.PROGRAMATICA,FUNCAO.POSICAO,FUNCAO.TAMANHO)) AS DESCRICAOFUNCAO,
       SUBSTR(DESP.PROGRAMATICA,SUBFUNCAO.POSICAO,SUBFUNCAO.TAMANHO) AS SUBFUNCAO,
       (SELECT PARAM.DESCRICAO FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA PARAM
          WHERE PARAM.ENTIDADE = DESP.ENTIDADE
         AND PARAM.EXERCICIO = DESP.EXERCICIO
         AND PARAM.MODELODESPESA = DESP.MODELODESPESA
         AND PARAM.TIPO = SUBFUNCAO.TIPO
         AND PARAM.ORDEM = SUBFUNCAO.ORDEM
         AND PARAM.CODIGO = SUBSTR(DESP.PROGRAMATICA,SUBFUNCAO.POSICAO,SUBFUNCAO.TAMANHO)) AS DESCRICAOSUBFUNCAO,
       SUBSTR(DESP.PROGRAMATICA,PROG.POSICAO,PROG.TAMANHO) AS PROGRAMA,
       (SELECT PARAM.DESCRICAO FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA PARAM
          WHERE PARAM.ENTIDADE = DESP.ENTIDADE
         AND PARAM.EXERCICIO = DESP.EXERCICIO
         AND PARAM.MODELODESPESA = DESP.MODELODESPESA
         AND PARAM.TIPO = PROG.TIPO
         AND PARAM.ORDEM = PROG.ORDEM
         AND PARAM.CODIGO = SUBSTR(DESP.PROGRAMATICA,PROG.POSICAO,PROG.TAMANHO)) AS DESCRICAOPROGRAMA,
       SUBSTR(DESP.PROGRAMATICA,PROJ.POSICAO,PROJ.TAMANHO) AS PROJETO,
       (SELECT PARAM.DESCRICAO FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA PARAM
          WHERE PARAM.ENTIDADE = DESP.ENTIDADE
         AND PARAM.EXERCICIO = DESP.EXERCICIO
         AND PARAM.MODELODESPESA = DESP.MODELODESPESA
         AND PARAM.TIPO = PROJ.TIPO
         AND PARAM.ORDEM = PROJ.ORDEM
         AND PARAM.CODIGO = SUBSTR(DESP.PROGRAMATICA,PROJ.POSICAO,PROJ.TAMANHO)) AS DESCRICAOPROJETO,
       SUBSTR(DESP.PROGRAMATICA,ELEM.POSICAO,ELEM.TAMANHO) AS ELEMENTO,
       (SELECT PARAM.DESCRICAO FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA PARAM
          WHERE PARAM.ENTIDADE = DESP.ENTIDADE
         AND PARAM.EXERCICIO = DESP.EXERCICIO
         AND PARAM.MODELODESPESA = DESP.MODELODESPESA
         AND PARAM.TIPO = ELEM.TIPO
         AND PARAM.ORDEM = ELEM.ORDEM
         AND PARAM.CODIGO = SUBSTR(DESP.PROGRAMATICA,ELEM.POSICAO,ELEM.TAMANHO)) AS DESCRICAOELEMENTO,
       E.DESDOBRADESP,     
       (SELECT DESD.DESCRICAO FROM ${db.contabilidade.schema}.DESDOBRADESP DESD
          WHERE DESD.ENTIDADE = DESP.ENTIDADE
         AND DESD.EXERCICIO = DESP.EXERCICIO
         AND DESD.DESPESA = SUBSTR(DESP.PROGRAMATICA,ELEM.POSICAO,6)
         AND DESD.DESDOBRAMENTO = E.DESDOBRADESP
         AND DESD.SUBDESDOBRAMENTO = '00') AS DESCRICAODESDOBRAMENTO,
       E.SUBDESDOBRAMENTO,     
       (SELECT DESD.DESCRICAO FROM ${db.contabilidade.schema}.DESDOBRADESP DESD
          WHERE DESD.ENTIDADE = DESP.ENTIDADE
         AND DESD.EXERCICIO = DESP.EXERCICIO
         AND DESD.DESPESA = SUBSTR(DESP.PROGRAMATICA,ELEM.POSICAO,6)
         AND DESD.DESDOBRAMENTO = E.DESDOBRADESP
         AND DESD.SUBDESDOBRAMENTO = E.SUBDESDOBRAMENTO) AS DESCRICAOSUBDESDOBRAMENTO,
       E.FONTERECURSO,
       FONTE.DESCRICAO AS DESCRICAOFONTE,
       FONTECONTRAPARTIDA.FONTERECURSO AS FONTECONTRAPARTIDA,
       FONTECONTRAPARTIDA.DESCRICAO AS DESCRICAOFONTECONTRAPARTIDA,	   
       E.NOCONTRATO,
       E.CONTRATO,
       E.ANOCONTRATO,
       CAST(CASE WHEN C.CODIGOVARIAVEL = '0' 
                THEN B.CDFONTEPADRAO || '.' || C.CDAPLICACAO 
                ELSE B.CDFONTEPADRAO || '.' || C.CDAPLICACAO || '.' || COALESCE(D.CODIGO, 0) 
            END AS VARCHAR(50))  AS CODIGOAPLICACAO, 
       CAST(CASE WHEN C.CODIGOVARIAVEL = '0' 
                THEN C.DSAPLICACAO 
                ELSE C.DSAPLICACAO || ' - ' || D.DESCRICAO 
            END AS VARCHAR(255)) AS DESCRICAOAPLICACAO,
	   E.TIPOCONTRATO,
	   E.ANONAD,
	   E.NONAD,
	   COALESCE(CRG.CODIGO || ' - ' || CRG.OCUPANTE, 'FISCAL NÃO ENCONTRADO') AS FISCALRESPONSAVEL,
	   E.CONTRAPARTIDA
  FROM ${db.contabilidade.schema}.EMPENHO E
  LEFT OUTER JOIN ${db.contabilidade.schema}.FORNECEDOR F
    ON E.FORNECEDOR = F.FORNECEDOR
  LEFT OUTER JOIN ${db.contabilidade.schema}.TIPOSLICITACAO LIC
    ON E.TIPOLICITACAO = LIC.TIPOLICITACAO
  LEFT OUTER JOIN ${db.contabilidade.schema}.TIPOSLICITACAOAPICE LICAPIC
    ON LIC.TIPOLICITACAO = LICAPIC.CONTABILIDADE
  LEFT OUTER JOIN ${db.contabilidade.schema}.DESPESA DESP
    ON E.ENTIDADE = DESP.ENTIDADE
   AND E.EXERCICIO = DESP.EXERCICIO
   AND E.PROGRAMATICA = DESP.PROGRAMATICA
   AND E.FONTERECURSO = DESP.FONTERECURSO
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA ORG
    ON DESP.MODELODESPESA = ORG.MODELODESPESA
   AND ORG.TIPO = 'P'
   AND ORG.ORDEM = 1
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA UNID
    ON DESP.MODELODESPESA = UNID.MODELODESPESA
   AND UNID.TIPO = 'C'
   AND UNID.ORDEM = 2
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA FUNCAO
    ON DESP.MODELODESPESA = FUNCAO.MODELODESPESA
   AND FUNCAO.TIPO = 'P'
   AND FUNCAO.ORDEM = 3
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA SUBFUNCAO
    ON DESP.MODELODESPESA = SUBFUNCAO.MODELODESPESA
   AND SUBFUNCAO.TIPO = 'P'
   AND SUBFUNCAO.ORDEM = 4
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA PROG
    ON DESP.MODELODESPESA = PROG.MODELODESPESA
   AND PROG.TIPO = 'P'
   AND PROG.ORDEM = 5
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA PROJ
    ON DESP.MODELODESPESA = PROJ.MODELODESPESA
   AND PROJ.TIPO = 'P'
   AND PROJ.ORDEM = 6
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA ELEM
    ON DESP.MODELODESPESA = ELEM.MODELODESPESA
   AND ELEM.TIPO = 'C'
   AND ELEM.ORDEM = 7
  LEFT OUTER JOIN ${db.contabilidade.schema}.FONTERECURSO FONTE
    ON E.FONTERECURSO = FONTE.FONTERECURSO
  LEFT OUTER JOIN ${db.contabilidade.schema}.CADASTROCONVENIO CC
    ON CC.ENTIDADE = E.ENTIDADE
   AND CC.ID = E.IDCONVENIO
  LEFT OUTER JOIN ${db.contabilidade.schema}.FONTERECURSO FONTECONTRAPARTIDA
    ON CC.FONTERECURSO = FONTECONTRAPARTIDA.FONTERECURSO
  LEFT JOIN ${db.contabilidade.schema}.FONTERECURSO FONTEVINCULADA
    ON FONTEVINCULADA.FONTERECURSO = E.FONTERECURSOVINCULADA
  LEFT JOIN ${db.contabilidade.schema}.FONTERECURSOPADRAO A
    ON A.CODIGO = FONTEVINCULADA.CODIGOFONTEPADRAO
  LEFT JOIN ${db.contabilidade.schema}.FONTEPADRAOTCE B
    ON B.CODIGO = A.CODIGOFONTEPADRAOTCE
   AND B.UF = 'SP' 
   AND B.CDFONTEPADRAO IN (SELECT G.CDFONTEPADRAO 
                             FROM ${db.contabilidade.schema}.FONTERECURSO FR
                             JOIN ${db.contabilidade.schema}.FONTERECURSOPADRAO F
                               ON FR.CODIGOFONTEPADRAO = F.CODIGO 
                             JOIN ${db.contabilidade.schema}.FONTEPADRAOTCE G
                               ON F.CODIGOFONTEPADRAOTCE = G.CODIGO 
                              AND G.UF = 'SP' 
                            WHERE FONTERECURSO = E.FONTERECURSO) 
  LEFT JOIN ${db.contabilidade.schema}.FONTEAPLICACAORECURSO C
    ON C.CODIGO = A.CODIGOAPLICACAO
   AND C.UF = 'SP' 
  LEFT JOIN ${db.contabilidade.schema}.FONTEAPLICACAORECURSOVARIAVEL D
    ON FONTEVINCULADA.FONTERECURSO = D.FONTERECURSO 
	LEFT JOIN ${db.compras.schema}.CLNAD CL
		ON CL.EMPENHO = E.EMPENHO
	 AND CL.ENTIDADE = E.ENTIDADE
	 AND CL.EXERCICIO = E.EXERCICIO
	 AND CL.NUMERONAD = E.NONAD
	LEFT JOIN ${db.compras.schema}.CLCARGO CRG
		ON CRG.ENTIDADE = E.ENTIDADE
	 AND CRG.EXERCICIO = E.EXERCICIO
	 AND CRG.CODIGO = CL.FISCAL	 
