SELECT TB2.*
FROM
(SELECT TB1.RECEITA,
       TB1.DESCRICAO,
			 TB1.NIVEL,
			 TB1.INICIO,
			 TB1.TAMANHO,	
			 TB1.ACEITAMOVIMENTACAO,
			 SUM(TB1.VALORORCADO) AS VALORORCADO,
			 SUM(TB1.VALORORCADO) + SUM(TB1.VALORATUALIZADO) AS VALORATUALIZADO,
       SUM(TB1.VALORARRECADADO) AS VALORARRECADADO        
FROM
(SELECT SUBSTR(R.RECEITA,1, R.INICIO+R.TAMANHO-1) AS RECEITA,
        COALESCE(PR.DESCRICAO,R.DESCRICAO) AS DESCRICAO,
	      R.NIVEL, 
				R.INICIO,
				R.TAMANHO,
				R.MOVSN AS ACEITAMOVIMENTACAO,
       COALESCE(((COALESCE(R.VALORORCADO,0)/100) * COALESCE(RECEITA_FONTETCE.PERCENTUAL,0)),0) AS VALORORCADO,
			 ((SELECT SUM(COALESCE(RECEITAMENSAL.VALORCORRECAOORCADO,0) + COALESCE(RECEITAMENSAL.VALORCORRECAO,0))                                                                                           
					 FROM ${db.contabilidade.schema}.RECEITAMENSAL RECEITAMENSAL
					 WHERE  RECEITAMENSAL.ENTIDADE              = R.ENTIDADE                                                                                                                                 
					 AND    RECEITAMENSAL.EXERCICIO					    = R.EXERCICIO                                                                                                                                
					 AND    RECEITAMENSAL.RECEITA								= R.RECEITA                                                                                                                                  
					 AND    RECEITAMENSAL.FONTERECURSO					= R.FONTERECURSO                                                                                                                             
					 AND    RECEITAMENSAL.IDTIPOOPERACAORECEITA = R.IDTIPOOPERACAORECEITA) /100) * COALESCE(RECEITA_FONTETCE.PERCENTUAL,0) VALORATUALIZADO,
           COALESCE((SELECT SUM(CASE WHEN RR.GRUPOEVENTO in (11,14) then RRI.VALOR else RRI.VALOR*-1 END) 
           FROM ${db.contabilidade.schema}.REALIZACAORECEITA RR
           JOIN ${db.contabilidade.schema}.REALIZACAORECEITAITEM RRI
           ON     RRI.ENTIDADE     = RR.ENTIDADE                                                
           AND    RRI.EXERCICIO    = RR.EXERCICIO                                               
           AND    RRI.LANCAMENTO   = RR.LANCAMENTO                                              
           WHERE  RR.ENTIDADE        = R.ENTIDADE                               
           AND 	  RR.EXERCICIO       = R.EXERCICIO                                        
           AND    RR.RECEITA         = R.RECEITA                                        
           AND    RRI.FONTERECURSO   = FONTERECURSO.FONTERECURSO
           AND    RRI.IDTIPOOPERACAORECEITA = R.IDTIPOOPERACAORECEITA),0) AS VALORARRECADADO
FROM ${db.contabilidade.schema}.RECEITA R

LEFT JOIN ${db.contabilidade.schema}.ORCPARAMETRORECEITA PR
    ON R.ENTIDADE      = PR.ENTIDADE
   AND R.EXERCICIO 		 = PR.EXERCICIO
   AND R.MODELORECEITA = PR.MODELORECEITA
   AND R.TIPO 			   = PR.TIPO
   AND R.NIVEL 				 = PR.ORDEM
   AND R.RECEITA 			 = PR.CODIGO

JOIN ${db.contabilidade.schema}.RECEITA_FONTETCE RECEITA_FONTETCE
	ON  RECEITA_FONTETCE.ENTIDADE    	        = R.ENTIDADE     
 AND RECEITA_FONTETCE.EXERCICIO             = R.EXERCICIO     
 AND RECEITA_FONTETCE.RECEITA               = R.RECEITA       
 AND RECEITA_FONTETCE.FONTERECURSO          = R.FONTERECURSO  
 AND RECEITA_FONTETCE.IDTIPOOPERACAORECEITA = R.IDTIPOOPERACAORECEITA

JOIN ${db.contabilidade.schema}.FONTERECURSO FONTERECURSO
ON  FONTERECURSO.FONTERECURSO = RECEITA_FONTETCE.VINCULOFONTERECURSO 

WHERE  R.ENTIDADE  		         = :entidade
AND    R.EXERCICIO               = :exercicio
AND    FONTERECURSO.FONTERECURSO = :fonteRecurso
) TB1
 GROUP BY TB1.RECEITA, TB1.DESCRICAO, TB1.NIVEL, TB1.INICIO, TB1.TAMANHO, TB1.ACEITAMOVIMENTACAO
 ORDER BY TB1.RECEITA, TB1.DESCRICAO
) TB2
WHERE (TB2.VALORORCADO > 0 OR TB2.VALORATUALIZADO > 0 OR TB2.VALORARRECADADO > 0)