SELECT D.ENTIDADE, D.EXERCICIO, SUBSTR(D.PROGRAMATICA,1, D.INICIO+D.TAMANHO-1) AS PROGRAMATICA, D.DESCRICAO, D.NIVEL, D.INICIO, D.TAMANHO, D.MOVSN AS ACEITAMOVIMENTACAO, 
       SUM(D.VALORPREVISTO) AS VALORPREVISTO,
       SUM(D.VALORPREVISTO + DESPESADIARIA.VALORATUALIZADO) AS VALORATUALIZADO,
       SUM(DESPESADIARIA.VALOREMPENHADO) AS VALOREMPENHADO,
       SUM(DESPESADIARIA.VALORALIQUIDAR) AS VALOREMLIQUIDACAO,
       SUM(DESPESADIARIA.VALORLIQUIDADO) AS VALORLIQUIDADO,
       SUM(DESPESADIARIA.VALORPAGO) AS VALORPAGO
  FROM ${db.contabilidade.schema}.DESPESA D
  LEFT JOIN (SELECT ENTIDADE, EXERCICIO, PROGRAMATICA, FONTERECURSO,
                    SUM(DESPESADIARIA.VALORSUPLEMENTACAO - DESPESADIARIA.VALORESTSUPLEMENTACAO) AS VALORSUPLEMENTADO,
                    SUM(DESPESADIARIA.VALORREDUCAO - DESPESADIARIA.VALORESTREDUCAO) AS VALORREDUZIDO,
                    SUM(0 + DESPESADIARIA.VALORSUPLEMENTACAO - DESPESADIARIA.VALORESTSUPLEMENTACAO - DESPESADIARIA.VALORREDUCAO + DESPESADIARIA.VALORESTREDUCAO) AS VALORATUALIZADO,
                    SUM(0) AS VALORCORRECAOPREVISTO, 
                    SUM(DESPESADIARIA.VALOREMPENHO - DESPESADIARIA.VALORANULACAOEMPENHO + DESPESADIARIA.VALORESTANULACAOEMPENHO) AS VALOREMPENHADO, 
                    SUM(DESPESADIARIA.VALORLIQUIDACAO - DESPESADIARIA.VALORESTLIQUIDACAO) AS VALORLIQUIDADO,
                    SUM(DESPESADIARIA.VALORPAGAMENTO - DESPESADIARIA.VALORESTPAGAMENTO + DESPESADIARIA.VALORRETENCAO) AS VALORPAGO,
                    SUM(DESPESADIARIA.VALOREMPENHO - DESPESADIARIA.VALORANULACAOEMPENHO + DESPESADIARIA.VALORESTANULACAOEMPENHO -
                        DESPESADIARIA.VALORLIQUIDACAO + DESPESADIARIA.VALORESTLIQUIDACAO) AS VALORALIQUIDAR
               FROM ${db.contabilidade.schema}.DESPESADIARIA
              WHERE ENTIDADE  = ?
                AND EXERCICIO = ?
                $[FILTRODESPESADIARIA]
              GROUP BY ENTIDADE, EXERCICIO, PROGRAMATICA, FONTERECURSO 
            ) DESPESADIARIA
    ON D.ENTIDADE     = DESPESADIARIA.ENTIDADE
   AND D.EXERCICIO    = DESPESADIARIA.EXERCICIO
   AND D.PROGRAMATICA = DESPESADIARIA.PROGRAMATICA 
   AND D.FONTERECURSO = DESPESADIARIA.FONTERECURSO 
 WHERE D.ENTIDADE = ?
   AND D.EXERCICIO = ?
 GROUP BY D.ENTIDADE, D.EXERCICIO, SUBSTR(D.PROGRAMATICA,1, D.INICIO+D.TAMANHO-1), D.DESCRICAO, D.NIVEL, D.INICIO, D.TAMANHO, D.MOVSN
 ORDER BY SUBSTR(D.PROGRAMATICA,1, D.INICIO+D.TAMANHO-1)