
SELECT D.DESCRICAO AS ORGAOPUBLICACAO,
       B.DATA AS DATAPUBLICACAO,
       case when ARQ.NOMEARQUIVO is null then ELOARQ.NOME else ARQ.NOMEARQUIVO end as NOMEARQUIVO,
       ARQ.IDARQUIVO,
       ARQ.DATA,
       LENGTH(AC.ARQUIVO) AS TAMANHOARQUIVO,
       C.DESCRICAO AS TIPOPUBLICACAO
  FROM ${db.compras.schema}.CLLICITACAO A
  LEFT JOIN ${db.compras.schema}.CLLICITACAOPUBLICACAO B
    ON A.TIPOLICITACAO = B.TIPOLICITACAO
   AND A.LICITACAO = B.LICITACAO
   AND A.EXERCICIO = B.EXERCICIO
   AND A.ENTIDADE = B.ENTIDADE
  LEFT JOIN ${db.compras.schema}.ARQUIVO ARQ
    ON ARQ.ID = B.IDARQUIVO
   AND COALESCE(ARQ.ARQUIVOSIGILOSO,'N') <> 'S'
  LEFT JOIN ${db.compras.schema}.CLTIPOPUBLICACAO C
    ON B.TIPOPUBLICACAO = C.TIPOPUBLICACAO
  LEFT JOIN ${db.compras.schema}.CLORGAOPUBLICACAO D
    ON B.ORGAOPUBLICACAO = D.ORGAOPUBLICACAO
  LEFT JOIN schema_eloarquivo.ARQUIVO ELOARQ
     ON ELOARQ.ID = ARQ.IDARQUIVO  
  LEFT JOIN schema_eloarquivo.ARQUIVO_CONTENT AC
     ON ARQ.IDARQUIVO = AC.ID  
 WHERE A.ENTIDADE = :entidade
   AND A.EXERCICIO = :exercicio
   AND A.TIPOLICITACAO = :tipoLicitacao
   AND A.LICITACAO = :licitacao
 ORDER BY ELOARQ.ID
