SELECT tc.descricao as descricaoTipoCadastro,
       cg.cadastrogeral,
       tci.setor_descr as setor,
       tci.quadra_descr as quadra,
       tci.lote_descr as lote,
       g.descricao as descricaoDivida,
       case 
         when tdp.situacaolegal = 0 then '0 - No Exercicio'
         when tdp.situacaolegal = 1 then '1 - Divida Ativa'
         else '2 - Ajuizado'
       end as situacaoLegal,
       case
         when tdp.situacaolegal <> 0 and tdp.situacaolegal <> 1 then 'Execução Fiscal'
         when tdp.idprotesto is not null and tprotesto.situacao = 'GE' then 'Protestado'
         else 'Admnistrativa'
       end as condicao,
        case when (coalesce( g.GUIATRIBUTARIA, 'N' ) = 'S') then 'Tributária' else 'Não Tributária' end as guiaTributaria,
       sum(coalesce(tdpr.valor, 0)) as valor
  FROM ${db.aise.schema}.tribdebitoparcelareceita tdpr
  LEFT OUTER JOIN ${db.aise.schema}.tribdebitoparcela tdp
    ON tdp.entidade = tdpr.entidade
   AND tdp.exercicio = tdpr.exercicio
   AND tdp.tipocadastro = tdpr.tipocadastro
   AND tdp.cadastrogeral = tdpr.cadastrogeral
   AND tdp.guiarecolhimento = tdpr.guiarecolhimento
   AND tdp.subdivida = tdpr.subdivida
   AND tdp.parcela = tdpr.parcela
  LEFT OUTER JOIN ${db.aise.schema}.tribcadastroimobiliario tci
    ON tdp.tipocadastro = tci.tipocadastro
   AND tdp.cadastrogeral = tci.cadastrogeral
  LEFT OUTER JOIN ${db.aise.schema}.tribcadastrogeral cg
    ON tdp.tipocadastro = cg.tipocadastro
   AND tdp.cadastrogeral = cg.cadastrogeral
  LEFT OUTER JOIN ${db.aise.schema}.pessoa p
    ON p.pessoa = cg.pessoa
  LEFT OUTER JOIN ${db.aise.schema}.tribtipocadastro tc
    ON cg.tipocadastro = tc.tipocadastro
  LEFT OUTER JOIN ${db.aise.schema}.tribsituacaoparcela tsp
    ON tsp.situacaoparcela = tdp.situacaodebito
  LEFT OUTER JOIN ${db.aise.schema}.tribtiposituacaoparcela ttsp
    ON tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela
  LEFT OUTER JOIN ${db.aise.schema}.tribguiarecolhimento g
    ON tdp.entidade = g.entidade
   AND tdp.exercicio = g.exercicio
   AND tdp.guiarecolhimento = g.guiarecolhimento 
  LEFT OUTER JOIN ${db.aise.schema}.tribprotesto tprotesto
    ON tdp.idprotesto = tprotesto.idprotesto
 WHERE P.PESSOA IN (:idContribuinte)
   AND tdp.situacaolegal in (1,2)
   AND ttsp.tipo = 'A'
$[FILTRO]
 group by tc.Descricao, cg.CadastroGeral, tci.Setor_Descr, tci.Quadra_Descr, tci.Lote_Descr, g.Descricao,
 case  
   when tdp.situacaolegal = 0 then '0 - No Exercicio'
   when tdp.situacaolegal = 1 then '1 - Divida Ativa'
   else '2 - Ajuizado'
 end,  
 case  
   when tdp.situacaolegal <> 0 and tdp.situacaolegal <> 1 then 'Execução Fiscal'
   when tdp.idprotesto is not null and tprotesto.situacao = 'GE' then 'Protestado' else 'Admnistrativa' end,
 g.guiaTributaria
 order by tc.Descricao, cg.CadastroGeral, tci.Setor_Descr, tci.Quadra_Descr, tci.Lote_Descr