/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.smtportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.DividaAtivaContribuinteDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.DividaAtivaDTO;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindDividaAtivaParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.smtportal.repository.DividaAtivaSmtRepository;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DividaAtivaSmtRepositoryImpl
implements DividaAtivaSmtRepository {
    private static final String DIVIDAS_ATIVAS_SMT = "db/sql/smt/dividas-ativas-smt.sql";
    private static final String DIVIDAS_ATIVAS_COUNT_SMT = "db/sql/smt/dividas-ativas-count-smt.sql";
    private static final String DIVIDAS_ATIVAS_CONTRIBUINTE_SMT = "db/sql/smt/dividas-ativas-contribuinte-smt.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public DividaAtivaSmtRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public Page<DividaAtivaDTO> findDividasAtivas(FindDividaAtivaParams params, Pageable pageable) {
        String query = this.concatenarFiltros(params, FileUtils.readResourceAsString((String)DIVIDAS_ATIVAS_SMT)).toString();
        MapSqlParameterSource namedParameter = params.toJdbcParameter().addValue("start", (Object)pageable.getOffset()).addValue("end", (Object)(pageable.getOffset() + (long)pageable.getPageSize()));
        List dividas = this.getJdbcTemplate().query(query, (SqlParameterSource)namedParameter, (RowMapper)new ElotechBeanPropertyRowMapper(DividaAtivaDTO.class));
        return new PageImpl(dividas, pageable, this.countDividasAtivas(params).longValue());
    }

    public List<DividaAtivaContribuinteDTO> findDividasAtivasContribuinte(FindDividaAtivaParams params) {
        StringBuilder query = this.concatenarFiltros(params, FileUtils.readResourceAsString((String)DIVIDAS_ATIVAS_CONTRIBUINTE_SMT));
        return this.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(DividaAtivaContribuinteDTO.class));
    }

    private Long countDividasAtivas(FindDividaAtivaParams params) {
        String queryCount = this.concatenarFiltros(params, FileUtils.readResourceAsString((String)DIVIDAS_ATIVAS_COUNT_SMT)).toString();
        return (Long)this.getJdbcTemplate().queryForObject(queryCount, (SqlParameterSource)params.toJdbcParameter(), Long.class);
    }

    private StringBuilder concatenarFiltros(FindDividaAtivaParams params, String sqlOriginal) {
        StringBuilder filtro = new StringBuilder();
        params.getNomeFiltro().ifPresent(i -> filtro.append(" AND LOWER(p.nome) LIKE LOWER(:nomeFiltro) "));
        if (params.getSomenteAjuizado().booleanValue()) {
            filtro.append(" AND vp.Situacao = 2 ");
        }
        return new StringBuilder(sqlOriginal.replace("$[FILTRO]", filtro.toString()));
    }

    @VisibleForTesting
    protected NamedParameterJdbcTemplate getJdbcTemplate() {
        return this.datasourceWrapper.getJdbcTemplate();
    }
}

