/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.sei.resource;

import br.com.elotech.gatewayprocessos.client.dto.ProcessoDTO;
import br.com.elotech.gatewayprocessos.client.dto.ProcessoParams;
import br.com.elotech.portaltransparencia.protocportal.params.SalvaProcessoParams;
import br.com.elotech.portaltransparencia.sei.ProcessoSeiDTO;
import br.com.elotech.portaltransparencia.sei.service.ProcessoSeiService;
import java.util.Calendar;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/processos-sei"})
public class ProcessoSeiResource {
    private final ProcessoSeiService processoSeiService;

    @PostMapping
    public ResponseEntity<ProcessoSeiDTO> saveProcesso(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid @RequestBody SalvaProcessoParams params) {
        params.setEntidade(entidade);
        params.setExercicio(Optional.ofNullable(exercicio).orElseGet(() -> Calendar.getInstance().get(1)));
        return ResponseEntity.ok((Object)this.processoSeiService.salvarProcesso(params));
    }

    @GetMapping
    public ResponseEntity<ProcessoDTO> findProcesso(ProcessoParams processoParams) {
        return ResponseEntity.ok((Object)this.processoSeiService.findProcesso(processoParams));
    }

    @Generated
    public ProcessoSeiResource(ProcessoSeiService processoSeiService) {
        this.processoSeiService = processoSeiService;
    }
}

