/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.contabilidade.client.InterferenciaFinanceiraFeignClient;
import br.com.elotech.contabilidade.client.dto.DemonstrativoInterferenciaFinanceiraDTO;
import br.com.elotech.contabilidade.client.dto.RepasseInterferenciaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RepasseDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RepasseMesDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RepasseRecebidoDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindRepasseParams;
import br.com.elotech.portaltransparencia.contabportal.service.RepasseService;
import br.com.elotech.portaltransparencia.utils.PrecisionUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class RepasseOxyServiceImpl
implements RepasseService {
    private static final Long INGRESSO = 1L;
    private static final Long EGRESSO = 2L;
    private static final Map<String, Long> TIPO_REPASSE_MAP = Map.of("R", INGRESSO, "E", EGRESSO);
    private final InterferenciaFinanceiraFeignClient feignClient;

    public List<RepasseDTO> findRepasses(FindRepasseParams params) {
        return this.feignClient.findRepasseInterferenciaDTO(params.getEntidade(), params.getExercicio(), (Long)TIPO_REPASSE_MAP.get(params.getTipo()), params.getDataInicial().orElse(LocalDate.of(Math.toIntExact(params.getExercicio()), 1, 1)), params.getDataFinal().orElse(LocalDate.of(Math.toIntExact(params.getExercicio()), 12, 31))).stream().map(it -> RepasseDTO.ofDemonstrativo((RepasseInterferenciaDTO)it, (String)params.getTipo(), (Long)params.getEntidade(), (Long)params.getExercicio())).toList();
    }

    public List<RepasseMesDTO> findRepassesEnviadosMes(FindRepasseParams params) {
        return this.feignClient.findDetalheByExtraOrcamentarioAndEntidadesAndDataBetween(params.getIdContaCorrente().map(Objects::toString).orElse(""), params.getEntidade().toString(), params.getDataInicial().orElse(LocalDate.of(Math.toIntExact(params.getExercicio()), 1, 1)), params.getDataFinal().orElse(LocalDate.of(Math.toIntExact(params.getExercicio()), 12, 31))).stream().filter(item -> this.filterDemonstrativo(params.getTipo(), item)).map(item -> RepasseMesDTO.ofDemonstrativo((DemonstrativoInterferenciaFinanceiraDTO)item, (String)params.getTipo())).collect(Collectors.toList());
    }

    public List<RepasseMesDTO> findRepassesRecebidosMes(FindRepasseParams params) {
        return this.feignClient.findDetalheByExtraOrcamentarioAndEntidadesAndDataBetween(params.getIdContaCorrente().map(Objects::toString).orElse(""), params.getEntidade().toString(), params.getDataInicial().orElse(LocalDate.of(Math.toIntExact(params.getExercicio()), 1, 1)), params.getDataFinal().orElse(LocalDate.of(Math.toIntExact(params.getExercicio()), 12, 31))).stream().filter(item -> this.filterDemonstrativo(params.getTipo(), item)).map(item -> RepasseMesDTO.ofDemonstrativo((DemonstrativoInterferenciaFinanceiraDTO)item, (String)params.getTipo())).collect(Collectors.toList());
    }

    private boolean filterDemonstrativo(String tipo, DemonstrativoInterferenciaFinanceiraDTO item) {
        return tipo.equals("R") && PrecisionUtils.isDifferentFromZero((BigDecimal)item.getIngresso()) != false || tipo.equals("E") && PrecisionUtils.isDifferentFromZero((BigDecimal)item.getEgresso()) != false;
    }

    public Page<RepasseRecebidoDTO> findRepassesRecebidos(FindRepasseParams params, Pageable pageable) {
        List repasseList = this.feignClient.findDemonstrativoByEntidadesAndDataBetween(params.getEntidade().toString(), params.getDataInicial().orElse(LocalDate.of(Math.toIntExact(params.getExercicio()), 1, 1)), params.getDataFinal().orElse(LocalDate.of(Math.toIntExact(params.getExercicio()), 12, 31))).stream().filter(item -> this.filterDemonstrativo(params.getTipo(), item)).map(item -> RepasseRecebidoDTO.ofDemonstrativo((DemonstrativoInterferenciaFinanceiraDTO)item, (String)params.getTipo())).collect(Collectors.toList());
        return new PageImpl(repasseList, pageable, (long)repasseList.size());
    }

    @Generated
    public RepasseOxyServiceImpl(InterferenciaFinanceiraFeignClient feignClient) {
        this.feignClient = feignClient;
    }
}

