/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.contabilidade.client.ReembolsoRessarcimentoFeignClient;
import br.com.elotech.contabilidade.client.enums.TipoSolicitacaoReembolso;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ReembolsoRessarcimentoDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.ReembolsoRessarcimentoParams;
import br.com.elotech.portaltransparencia.contabportal.service.ReembolsoRessarcimentoService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class ReembolsoRessarcimentoOxyServiceImpl
implements ReembolsoRessarcimentoService {
    private static final HashMap<String, Function<Sort.Direction, Sort.Order>> ORDERS = new HashMap();
    private static final HashMap<String, Function<String, String>> FILTERS = new HashMap();
    private final ReembolsoRessarcimentoFeignClient feign;

    public Page<ReembolsoRessarcimentoDTO> findReembolsosRessarcimentos(ReembolsoRessarcimentoParams params, Pageable pageable) {
        EloPage reembolsos = this.feign.findAllReembolso(this.buildSearch(params), this.buildSort(pageable));
        List reembolsosDto = reembolsos.getContent().stream().map(ReembolsoRessarcimentoDTO::fromReembolsoMovimentacaoDTO).collect(Collectors.toList());
        return new PageImpl(reembolsosDto, pageable, (long)reembolsos.getSize());
    }

    public ReembolsoRessarcimentoDTO findReembolsoRessarcimento(Long reembolsoId) {
        return this.feign.findReembolso(reembolsoId).map(ReembolsoRessarcimentoDTO::fromReembolsoMovimentacaoDTO).orElseThrow(() -> RestException.notFound((String)"N\u00e3o foi poss\u00edvel encontrar este Reembolso/Ressarcimento."));
    }

    public List<ArquivoPessoalDTO> findArquivos(Long reembolsoId) {
        return this.feign.findAnexosByReembolsoId(reembolsoId).stream().map(ArquivoPessoalDTO::of).collect(Collectors.toList());
    }

    public List<TipoSolicitacaoReembolso> getTiposReembolso() {
        return this.feign.findAllTipoReembolsoMovimentacao();
    }

    private String buildSearch(ReembolsoRessarcimentoParams params) {
        StringBuilder search = new StringBuilder();
        Optional.ofNullable(params.getEntidade()).ifPresent(entidade -> search.append((String)((Function)FILTERS.get("entidade")).apply(entidade.toString())));
        Optional.ofNullable(params.getExercicio()).ifPresent(exercicio -> search.append((String)((Function)FILTERS.get("exercicio")).apply(exercicio.toString())));
        Optional.ofNullable(params.getServidor()).ifPresent(servidor -> search.append((String)((Function)FILTERS.get("servidor")).apply(servidor)));
        Optional.ofNullable(params.getDestino()).ifPresent(destino -> search.append((String)((Function)FILTERS.get("destino")).apply(destino)));
        Optional.ofNullable(params.getEmpresaFornecedora()).ifPresent(empresaFornecedora -> search.append((String)((Function)FILTERS.get("empresaFornecedora")).apply(empresaFornecedora)));
        Optional.ofNullable(params.getTipoSolicitacao()).ifPresent(tipoSolicitacao -> search.append((String)((Function)FILTERS.get("tipoSolicitacao")).apply(tipoSolicitacao.toString())));
        return search.substring(0);
    }

    private Pageable buildSort(Pageable pageable) {
        ArrayList orders = new ArrayList();
        if (pageable.getSort().isSorted()) {
            pageable.getSort().toList().forEach(sort -> orders.add((Sort.Order)((Function)ORDERS.get(sort.getProperty())).apply(sort.getDirection())));
        }
        return PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.by(orders));
    }

    @Generated
    public ReembolsoRessarcimentoOxyServiceImpl(ReembolsoRessarcimentoFeignClient feign) {
        this.feign = feign;
    }

    static {
        ORDERS.put("numeroSolicitacao", direction -> new Sort.Order(direction, "numeroSolicitacao"));
        ORDERS.put("servidor", direction -> new Sort.Order(direction, "servidor.nome"));
        ORDERS.put("dataSaida", direction -> new Sort.Order(direction, "dataInicio"));
        ORDERS.put("dataRetorno", direction -> new Sort.Order(direction, "dataFim"));
        ORDERS.put("destino", direction -> new Sort.Order(direction, "destinoViagem.descricao"));
        ORDERS.put("dataSolicitacao", direction -> new Sort.Order(direction, "dataSolicitacao"));
        ORDERS.put("empresaFornecedora", direction -> new Sort.Order(direction, "empresaFornecedora.nome"));
        ORDERS.put("cnpjCpfEmpressaFornecedora", direction -> new Sort.Order(direction, "empresaFornecedora.cnpjCpf"));
        ORDERS.put("valor", direction -> new Sort.Order(direction, "valor"));
        FILTERS.put("entidade", filter -> "exercicio.entidade.id==" + filter);
        FILTERS.put("exercicio", filter -> ";exercicio.exercicio==" + filter);
        FILTERS.put("servidor", filter -> ";servidor.nome=='*" + filter + "*'");
        FILTERS.put("destino", filter -> ";destinoViagem.descricao=='*" + filter + "*'");
        FILTERS.put("empresaFornecedora", filter -> ";empresaFornecedora.nome=='*" + filter + "*'");
        FILTERS.put("tipoSolicitacao", filter -> ";tipoSolicitacao==" + filter);
    }
}

