/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.orcamento.client.EmendaParlamentarFeignClient;
import br.com.elotech.orcamento.client.dto.EmendaParlamentarDTO;
import br.com.elotech.portaltransparencia.admportal.domain.EmendaParlamentar;
import br.com.elotech.portaltransparencia.admportal.resource.params.EmendaParlamentarParams;
import br.com.elotech.portaltransparencia.arquivoportal.repository.EloArquivoRepository;
import br.com.elotech.portaltransparencia.contabportal.domain.ArquivoContab;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.converter.EmendaParlamentarConverter;
import br.com.elotech.portaltransparencia.contabportal.repository.ArquivoContabRepository;
import br.com.elotech.portaltransparencia.contabportal.service.ArquivoContabilService;
import br.com.elotech.portaltransparencia.contabportal.service.EmendaParlamentarService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpEntity;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class EmendaParlamentarOxyService
implements EmendaParlamentarService {
    private final EmendaParlamentarFeignClient emendaParlamentarFeignClient;
    private final ArquivoContabilService arquivoService;
    private final ArquivoContabRepository arquivoContabRepository;
    private final EloArquivoRepository eloArquivoRepository;

    public Page<EmendaParlamentar> findByParams(EmendaParlamentarParams params, Pageable pageable) {
        Pageable mappedPageable = this.mapSortFields(pageable);
        EloPage eloPage = Optional.ofNullable(this.emendaParlamentarFeignClient.findBy(this.buildFilterString(params), mappedPageable)).map(HttpEntity::getBody).orElse(new EloPage());
        List content = eloPage.getContent().stream().map(EmendaParlamentarConverter::fromDTO).collect(Collectors.toList());
        return new PageImpl(content, pageable, eloPage.getTotalElements());
    }

    public EmendaParlamentar findOne(Long id) {
        return Optional.ofNullable(this.emendaParlamentarFeignClient.findOne(id)).map(EmendaParlamentarConverter::fromDTO).map(arg_0 -> this.enrichWithArquivoInfo(arg_0)).orElse(null);
    }

    public EmendaParlamentar save(EmendaParlamentar emenda) throws IOException {
        MultipartFile arquivoTransient = emenda.getArquivoTransient();
        if (arquivoTransient != null && !arquivoTransient.isEmpty()) {
            ArquivoContab arquivoSalvo = this.arquivoService.salvarArquivo(arquivoTransient, arquivoTransient.getOriginalFilename());
            emenda.setArquivo(arquivoSalvo);
            emenda.setArquivoId(arquivoSalvo.getEloArquivo().getId());
            emenda.setArquivoNomeOriginal(arquivoSalvo.getNome());
        }
        EmendaParlamentarDTO emendaDto = EmendaParlamentarConverter.toDTO((EmendaParlamentar)emenda);
        EmendaParlamentarDTO savedDto = this.emendaParlamentarFeignClient.insert(emendaDto);
        return EmendaParlamentarConverter.fromDTO((EmendaParlamentarDTO)savedDto);
    }

    public EmendaParlamentar update(@NonNull EmendaParlamentar emenda) throws IOException {
        EmendaParlamentarDTO dtoExistente = this.emendaParlamentarFeignClient.findOne(emenda.getId());
        EmendaParlamentarDTO dtoAtualizado = EmendaParlamentarConverter.toDTO((EmendaParlamentar)emenda);
        dtoAtualizado.setId(dtoExistente.getId());
        this.processarAnexoParaUpdate(dtoAtualizado, emenda.getArquivoTransient(), dtoExistente.getArquivoId());
        EmendaParlamentarDTO dtoRetornado = this.emendaParlamentarFeignClient.insert(dtoAtualizado);
        return EmendaParlamentarConverter.fromDTO((EmendaParlamentarDTO)dtoRetornado);
    }

    public void delete(@NonNull EmendaParlamentar emendaParlamentar) {
        if (emendaParlamentar.getArquivoId() != null) {
            ArquivoContab arquivoContab = this.arquivoContabRepository.findByEloArquivoId(emendaParlamentar.getArquivoId());
            this.arquivoService.remove(arquivoContab.getId());
        }
        this.emendaParlamentarFeignClient.deleteById(emendaParlamentar.getId());
    }

    public EmendaParlamentar adicionarArquivoPublicacao(Long id, MultipartFile file) {
        return this.findOne(id);
    }

    public EmendaParlamentar removerArquivoPublicacao(Long id) {
        return this.findOne(id);
    }

    public List<EmendaParlamentar> findEmendaParlamentar(Long entidade, Long exercicio) {
        return null;
    }

    private void processarAnexoParaUpdate(EmendaParlamentarDTO dto, MultipartFile arquivoNovo, Long idArquivoExistente) throws IOException {
        if (arquivoNovo == null || arquivoNovo.isEmpty()) {
            dto.setArquivoId(idArquivoExistente);
            return;
        }
        if (idArquivoExistente != null) {
            ArquivoContab arquivoContabExistente = this.arquivoContabRepository.findByEloArquivoId(idArquivoExistente);
            ArquivoContab arquivoAtualizado = this.arquivoService.atualizarArquivo(arquivoContabExistente.getId(), arquivoNovo);
            this.updateDtoWithFileInfo(dto, arquivoAtualizado);
        } else {
            ArquivoContab arquivoSalvo = this.arquivoService.salvarArquivo(arquivoNovo, arquivoNovo.getOriginalFilename());
            this.updateDtoWithFileInfo(dto, arquivoSalvo);
        }
    }

    private void updateDtoWithFileInfo(EmendaParlamentarDTO dto, ArquivoContab arquivo) {
        dto.setArquivoId(arquivo.getEloArquivo().getId());
    }

    private EmendaParlamentar enrichWithArquivoInfo(EmendaParlamentar emenda) {
        if (emenda.getArquivoId() != null) {
            this.eloArquivoRepository.findById((Object)emenda.getArquivoId()).ifPresent(arquivo -> emenda.setArquivoNomeOriginal(arquivo.getNome()));
        }
        return emenda;
    }

    private String buildFilterString(EmendaParlamentarParams params) {
        ArrayList filters = new ArrayList();
        params.getEntidade().ifPresent(i -> filters.add("exercicio.entidade.id==" + i));
        params.getExercicio().ifPresent(i -> filters.add("exercicio.exercicio==" + i));
        params.getAutoria().ifPresent(a -> filters.add("autor=='*" + a + "*'"));
        params.getTipo().ifPresent(t -> filters.add("tipoEmenda=='*" + t + "*'"));
        params.getNumero().ifPresent(n -> filters.add("numero==" + n));
        params.getObjeto().ifPresent(o -> filters.add("descricao=='*" + o + "*'"));
        params.getFuncao().ifPresent(f -> filters.add("funcao=='*" + f + "*'"));
        return String.join((CharSequence)";", filters);
    }

    private Pageable mapSortFields(Pageable pageable) {
        if (pageable.getSort().isUnsorted()) {
            return pageable;
        }
        List mappedOrders = pageable.getSort().stream().map(arg_0 -> this.mapSortOrder(arg_0)).collect(Collectors.toList());
        Sort mappedSort = Sort.by(mappedOrders);
        return PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)mappedSort);
    }

    private Sort.Order mapSortOrder(Sort.Order order) {
        String mappedProperty = this.mapFieldName(order.getProperty());
        return new Sort.Order(order.getDirection(), mappedProperty);
    }

    private String mapFieldName(String fieldName) {
        switch (fieldName) {
            case "autoria": {
                return "autor";
            }
            case "tipo": {
                return "tipoEmenda";
            }
            case "objeto": {
                return "descricao";
            }
        }
        return fieldName;
    }

    @Generated
    public EmendaParlamentarOxyService(EmendaParlamentarFeignClient emendaParlamentarFeignClient, ArquivoContabilService arquivoService, ArquivoContabRepository arquivoContabRepository, EloArquivoRepository eloArquivoRepository) {
        this.emendaParlamentarFeignClient = emendaParlamentarFeignClient;
        this.arquivoService = arquivoService;
        this.arquivoContabRepository = arquivoContabRepository;
        this.eloArquivoRepository = eloArquivoRepository;
    }
}

