/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RepasseDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RepasseMesDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RepasseRecebidoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindRepasseParams;
import br.com.elotech.portaltransparencia.contabportal.service.RepasseService;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/repasses"})
public class RepasseResource {
    private static final String TIPO_RECEBIDO = "R";
    private final RepasseService service;
    private final BaseExport baseExport;
    private final EntidadeContabilidadeRepository entidadeRepository;

    public RepasseResource(RepasseService service, BaseExport baseExport, EntidadeContabilidadeRepository entidadeRepository) {
        this.baseExport = baseExport;
        this.entidadeRepository = entidadeRepository;
        this.service = service;
    }

    @GetMapping
    public ResponseEntity<List<RepasseDTO>> findRepasses(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, FindRepasseParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.service.findRepasses(params));
    }

    @GetMapping(value={"/recebidos"})
    public ResponseEntity<Page<RepasseRecebidoDTO>> findRepassesRecebidos(@RequestParam(value="entidade", required=false) Long entidade, @RequestParam(value="exercicio", required=false) Long exercicio, @Valid FindRepasseParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.service.findRepassesRecebidos(params, pageable));
    }

    @GetMapping(value={"/recebidos/report"})
    public ModelAndView findRepassesRecebidos(HttpServletRequest request, HttpServletResponse response, FindRepasseParams params, Pageable pageable) throws Throwable {
        Page page = this.service.findRepassesRecebidos(params, pageable);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Repasses Mensais Recebidos");
        reportParam.setClazzDTO(RepasseRecebidoDTO.class);
        reportParam.setHeaderFields("M\u00eas do Repasse,Valor Previsto (a),Duod\u00e9cimo Apurado (b),Repasse Recebido (c),Valor Previsto a Receber (d = a - c),%,Valor Apurado a Receber (e = b - c),%");
        reportParam.setFields("mes,valorPrevistoReceberMensal,valorAutorizadoMensal,valorRecebido,valorRestanteReceber,valorRecebidoSobrePrevisto,valorRestanteAutorizado,valorRecebidoSobreAutorizado");
        float[] fieldsPerc = new float[]{1.2f, 1.2f, 1.2f, 1.2f, 1.2f, 0.5f, 1.2f, 0.5f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{12, 12, 12, 12, 12, 5, 12, 5};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/report"})
    public ModelAndView findRepasses(HttpServletRequest request, HttpServletResponse response, FindRepasseParams params) throws Throwable {
        PageImpl page = new PageImpl(this.service.findRepasses(params));
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle(String.format("Repasses %s", this.getTipoRepasse(params.getTipo())));
        reportParam.setClazzDTO(RepasseDTO.class);
        if (TIPO_RECEBIDO.equals(params.getTipo())) {
            reportParam.setHeaderFields("\u00d3rg\u00e3o,Valor Previsto,Valor Recebido,Valor Devolvido,Valor a Receber");
            reportParam.setFields("nomeFornecedor,valorPrevistoReceber,valorLancado,valorDevolvido,valorRestanteReceber");
        } else {
            reportParam.setHeaderFields("\u00d3rg\u00e3o,Valor Previsto,Valor Repassado,Valor Recebido,Valor a Repassar");
            reportParam.setFields("nomeFornecedor,valorPrevistoRepassar,valorLancado,valorRecebido,valorRestanteRepassar");
        }
        float[] fieldsPerc = new float[]{5.2f, 1.2f, 1.2f, 1.2f, 1.2f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{52, 12, 12, 12, 12};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage((Page)page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"mes"}, params={"tipo"})
    public ResponseEntity<List<RepasseMesDTO>> findRepasses(@RequestParam(name="conta", required=false) String conta, @RequestParam(name="tipo") String tipo, FindRepasseParams params) {
        params.setTipo(tipo);
        if (conta != null) {
            params.setConta(conta);
        }
        if (TIPO_RECEBIDO.equals(params.getTipo())) {
            return ResponseEntity.ok((Object)this.service.findRepassesRecebidosMes(params));
        }
        return ResponseEntity.ok((Object)this.service.findRepassesEnviadosMes(params));
    }

    private String getTipoRepasse(String tipo) {
        if (TIPO_RECEBIDO.equals(tipo)) {
            return "Recebido";
        }
        return "Enviado";
    }

    @GetMapping(value={"/report/mes"})
    public ModelAndView exportRepassesMes(HttpServletRequest request, HttpServletResponse response, FindRepasseParams params) throws Throwable {
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle(String.format("Repasses %ss da conta %s", this.getTipoRepasse(params.getTipo()), params.getConta()));
        reportParam.setClazzDTO(RepasseMesDTO.class);
        reportParam.setHeaderFields("Data do Repasse,Banco,Hist\u00f3rico,Valor");
        reportParam.setFields("data,local,CompHist,valor");
        float[] fieldsPerc = new float[]{1.0f, 3.0f, 5.0f, 1.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{10, 30, 50, 10};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setSumFields("valor");
        reportParam.setPage((Page)new PageImpl(this.getItensReport(params)));
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    private List<RepasseMesDTO> getItensReport(FindRepasseParams params) {
        if (TIPO_RECEBIDO.equals(params.getTipo())) {
            return this.service.findRepassesRecebidosMes(params);
        }
        return this.service.findRepassesEnviadosMes(params);
    }
}

