/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.orcamento.client.dto.TipoOperacaoReceitaDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.EntidadeComprasDTO;
import br.com.elotech.portaltransparencia.comprasportal.service.impl.EntidadeComprasService;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RenunciaReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RenunciaReceitaDetalhesDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.RenunciaReceitaParams;
import br.com.elotech.portaltransparencia.contabportal.service.RenunciaReceitaService;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/contab/renuncia-receitas"})
public class RenunciaReceitaResource {
    private final RenunciaReceitaService renunciaReceitaService;
    private final ElotechProperties elotechProperties;
    private final EntidadeComprasService entidadeComprasService;
    private final BaseExport baseExport;

    public RenunciaReceitaResource(RenunciaReceitaService renunciaReceitaService, ElotechProperties elotechProperties, EntidadeComprasService entidadeComprasService, BaseExport baseExport) {
        this.renunciaReceitaService = renunciaReceitaService;
        this.elotechProperties = elotechProperties;
        this.entidadeComprasService = entidadeComprasService;
        this.baseExport = baseExport;
    }

    @GetMapping
    public ResponseEntity<Page<RenunciaReceitaDTO>> findRenuncias(@RequestParam(value="entidade", required=false) Long entidade, @RequestParam(value="exercicio", required=false) Long exercicio, @Valid RenunciaReceitaParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.renunciaReceitaService.findRenuncias(params, pageable));
    }

    @GetMapping(value={"/detalhes"})
    public ResponseEntity<Page<RenunciaReceitaDetalhesDTO>> findRenunciasDetalhes(@RequestHeader(value="entidade", required=false) Long entidade, @RequestHeader(value="exercicio", required=false) Long exercicio, @Valid RenunciaReceitaParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.renunciaReceitaService.findRenunciasDetalhes(params, pageable));
    }

    @GetMapping(value={"/tipoOperacaoReceita"})
    public ResponseEntity<TipoOperacaoReceitaDTO[]> getTipoOperacaoReceita() {
        return ResponseEntity.ok((Object)this.renunciaReceitaService.findTipoOperacaoReceita());
    }

    @GetMapping(value={"/report"})
    public ModelAndView exportRenuncias(HttpServletRequest request, HttpServletResponse response, @Valid RenunciaReceitaParams params, Pageable pageable) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.renunciaReceitaService.findRenuncias(params, (Pageable)pageRequest);
        EntidadeComprasDTO entidadeCompras = this.entidadeComprasService.findOne((Long)params.getEntidade().get());
        ReportParam reportParam = new ReportParam();
        if (Objects.nonNull(entidadeCompras)) {
            reportParam.setNomeEntidade(entidadeCompras.getNome());
        }
        reportParam.setReportTitle("Listagem das Ren\u00fancias de Receita");
        reportParam.setClazzDTO(RenunciaReceitaDTO.class);
        Long valor1 = (Long)params.getExercicio().get();
        Long valor2 = valor1 + 1L;
        Long valor3 = valor2 + 1L;
        reportParam.setHeaderFields("Esp\u00e9cie,Tipo,Setor/Programa/Benefici\u00e1rio,Medida, Fundamento Legal, Leis Atos," + valor1.toString() + "," + valor2.toString() + "," + valor3.toString());
        reportParam.setFields("descTipoTributo,descTipoModalidade,setorBeneficiario,compensacao,descfundamentolegal,idleis_atos,valorUm,valorDois,valorTres");
        float[] fieldsPerc = new float[]{0.6f, 1.0f, 2.0f, 1.0f, 1.0f, 0.6f, 0.8f, 0.8f, 0.8f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{60, 100, 200, 100, 100, 60, 80, 80, 80};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }
}

