/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.CreditosAdicionaisDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.CreditosAdicionaisParams;
import br.com.elotech.portaltransparencia.contabportal.service.CreditosAdicionaisService;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/creditosadicionais"})
public class CreditosAdicionaisResource {
    private final CreditosAdicionaisService creditosAdicionaisService;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;

    @Autowired
    public CreditosAdicionaisResource(CreditosAdicionaisService creditosAdicionaisService, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository, EntidadeContabilidadeService entidadeService) {
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
        this.creditosAdicionaisService = creditosAdicionaisService;
    }

    @GetMapping
    public ResponseEntity<Page<CreditosAdicionaisDTO>> findCreditosAdicionais(@RequestParam(value="entidade") Long entidade, @RequestParam(value="exercicio") Long exercicio, CreditosAdicionaisParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.creditosAdicionaisService.findCreditosAdicionais(params, pageable));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findCreditosAdicionaisExport(HttpServletRequest request, HttpServletResponse response, @Valid CreditosAdicionaisParams params, Pageable pageable) throws Throwable {
        params.setEntidade(params.getEntidade());
        params.setExercicio(params.getExercicio());
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.creditosAdicionaisService.findCreditosAdicionais(params, (Pageable)pageRequest);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Cr\u00e9ditos Adicionais");
        reportParam.setClazzDTO(CreditosAdicionaisDTO.class);
        reportParam.setHeaderFields("Despesa,Decreto,Natureza,Valor Inicial,Valor,Saldo Atualizado");
        reportParam.setFields("despesa,decreto,natureza,valorInicial,valor,saldoAtualizado");
        float[] fieldsPerc = new float[]{2.8f, 1.0f, 2.0f, 1.0f, 1.0f, 1.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{1000, 100, 100, 500, 100, 100, 100};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }
}

