/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.contabilidade.client.RealizacaoReceitaFeignClient;
import br.com.elotech.orcamento.client.CadastrosFeignClient;
import br.com.elotech.orcamento.client.dto.TipoOperacaoReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RenunciaReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RenunciaReceitaDetalhesDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.RenunciaReceitaRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.RenunciaReceitaParams;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository
public class RenunciaReceitaOxyRepositoryImpl
implements RenunciaReceitaRepository {
    private final CadastrosFeignClient cadastrosFeignClient;
    private final RealizacaoReceitaFeignClient realizacaoReceitaFeignClient;
    private static final Map<Long, Long> MODALIDADES_TO_OXY;
    private static final Map<String, Long> TIPO_TRIBUTO_OXY;
    private static final Long DEFAULT_MODALIDADE;
    private static final Map<Long, Map<Boolean, String>> RECEITAS_BY_TIPO_TRIBUTO;
    private static final Long INSS;
    private static final Long CONTRIBUICAO_MELHORIA;
    private static final Long OUTROS_TRIBUTOS;
    private static final Long TAXAS;
    private static final Long COSIP;
    private static final Long ITBI;
    private static final Long EXERCICIO_BASE;
    private static final Long IPTU;

    public Page<RenunciaReceitaDTO> findRenuncias(RenunciaReceitaParams params, Pageable pageable) {
        Long transientModalidade = Optional.ofNullable(params.getDescTipoModalidade()).flatMap(desc -> Optional.ofNullable(params.getTipoModalidadeOxy())).orElse(DEFAULT_MODALIDADE);
        Long modalidade = this.getModalidadeToOxy(transientModalidade);
        Long tipoTributo = params.getTipoTributo(params.getDescTipoTributo().orElse(""));
        String setorBeneficiario = params.getSetorBeneficiario().orElse(null);
        String compensacao = params.getCompensacao().orElse(null);
        List<RenunciaReceitaDTO> renuncias = this.cadastrosFeignClient.findAllRenunciasReceitasByExercicio(tipoTributo, modalidade, setorBeneficiario, (Long)params.getExercicio().get(), compensacao, (Long)params.getEntidade().get()).stream().map(RenunciaReceitaDTO::toPortalDTO).toList();
        return new PageImpl(renuncias, pageable, (long)renuncias.size());
    }

    public Page<RenunciaReceitaDetalhesDTO> findRenunciasDetalhes(RenunciaReceitaParams params, Pageable pageable) {
        Long tipoReceita = params.getIdTipoOperacaoReceita().orElse(null);
        String receita = params.getReceita().orElse(null);
        StringBuilder rsqlSearch = new StringBuilder();
        this.getFiltrosDetalhes((Long)params.getEntidade().get(), (Long)params.getExercicio().get(), receita, tipoReceita, (Long)TIPO_TRIBUTO_OXY.get(params.getDescTipoTributo().get()), rsqlSearch);
        List renunciasToPortalDTO = this.realizacaoReceitaFeignClient.findRenunciasRealizacoesPortal(rsqlSearch.toString(), params.getDataInicio(), params.getDataFim(), pageable.getPageNumber(), pageable.getPageSize());
        List<RenunciaReceitaDetalhesDTO> renuncias = renunciasToPortalDTO.stream().map(RenunciaReceitaDetalhesDTO::toDTO).toList();
        return new PageImpl(renuncias, pageable, (long)renuncias.size());
    }

    public TipoOperacaoReceitaDTO[] findTipoOperacaoReceita() {
        List tipos = this.cadastrosFeignClient.findAllTipoOperacaoreceita();
        return tipos.toArray(new TipoOperacaoReceitaDTO[0]);
    }

    public Long getModalidadeToOxy(Long modalidade) {
        return MODALIDADES_TO_OXY.getOrDefault(modalidade, null);
    }

    private void getFiltrosDetalhes(Long entidade, Long exercicio, String receita, Long tipoOperacaoReceita, Long tipoTributo, StringBuilder filterBuilder) {
        filterBuilder.append("entidade.id==").append(entidade).append(" and exercicio==").append(exercicio);
        Optional.ofNullable(receita).ifPresent(r -> filterBuilder.append(" or codigo==").append((String)r).append('*'));
        filterBuilder.append(" and codigo==").append((String)((Map)RECEITAS_BY_TIPO_TRIBUTO.get(tipoTributo)).get(exercicio < EXERCICIO_BASE));
        StringBuilder filtro = new StringBuilder();
        if (Optional.ofNullable(tipoOperacaoReceita).isPresent()) {
            filtro.append('(').append(tipoOperacaoReceita).append(')');
        } else {
            filtro.append("(2, 3, 4, 99)");
        }
        filterBuilder.append(" and tipoOperacaoReceita.id=in=").append((CharSequence)filtro);
    }

    @Generated
    public RenunciaReceitaOxyRepositoryImpl(CadastrosFeignClient cadastrosFeignClient, RealizacaoReceitaFeignClient realizacaoReceitaFeignClient) {
        this.cadastrosFeignClient = cadastrosFeignClient;
        this.realizacaoReceitaFeignClient = realizacaoReceitaFeignClient;
    }

    static {
        DEFAULT_MODALIDADE = 0L;
        INSS = 2L;
        CONTRIBUICAO_MELHORIA = 4L;
        OUTROS_TRIBUTOS = 6L;
        TAXAS = 5L;
        COSIP = 7L;
        ITBI = 3L;
        EXERCICIO_BASE = 2022L;
        IPTU = 1L;
        MODALIDADES_TO_OXY = Map.of(10L, 1L, 20L, 2L, 30L, 3L, 40L, 4L, 50L, 5L, 60L, 999L);
        RECEITAS_BY_TIPO_TRIBUTO = Map.of(IPTU, Map.of(Boolean.TRUE, "1118011*", Boolean.FALSE, "111250*"), ITBI, Map.of(Boolean.TRUE, "1118014*", Boolean.FALSE, "111253*"), INSS, Map.of(Boolean.TRUE, "1118023*", Boolean.FALSE, "1114511*"), CONTRIBUICAO_MELHORIA, Map.of(Boolean.TRUE, "113*", Boolean.FALSE, "113*"), TAXAS, Map.of(Boolean.TRUE, "112*", Boolean.FALSE, "112*"), COSIP, Map.of(Boolean.TRUE, "124*", Boolean.FALSE, "124*"));
        TIPO_TRIBUTO_OXY = Map.of("IPTU", IPTU, "INSS", INSS, "ITBI", ITBI, "CONTRIBUI\u00c7\u00c3O DE MELHORIA", CONTRIBUICAO_MELHORIA, "TAXAS", TAXAS, "OUTROS TRIBUTOS", OUTROS_TRIBUTOS, "COSIP", COSIP, "IMPUGNA\u00c7\u00d5ES/IMPOSI\u00c7\u00d5ES", 8L);
    }
}

