/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.MovimentoGaragemDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.MovimentoGaragemRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.MovimentoGaragemParams;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class MovimentoGaragemRepositoryImpl
implements MovimentoGaragemRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovimentoGaragemRepositoryImpl.class);
    private static final String MOVIMENTO_GARAGEM = "db/sql/contab/movimentoGaragem.sql";
    private static final String MOVIMENTO_GARAGEM_COUNT = "db/sql/contab/movimentoGaragemCount.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public MovimentoGaragemRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public Page<MovimentoGaragemDTO> findMovimentosGaragem(MovimentoGaragemParams params, Pageable pageable) {
        String sql = FileUtils.readResourceAsString((String)MOVIMENTO_GARAGEM);
        String count = FileUtils.readResourceAsString((String)MOVIMENTO_GARAGEM_COUNT);
        StringBuilder query = this.filtrosMovimentoGaragem(params, sql);
        String queryOrder = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)query.toString(), (String)"ORDER BY MOV_GARAGEM.DATASAIDA, MOV_GARAGEM.HORASAIDA, VEICULO.LETRAPLACA, VEICULO.NUMEROPLACA, VEICULO.DESCRICAO");
        sql = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)queryOrder, (String)this.datasourceWrapper.getPlatform());
        this.consoleLogger(params, sql);
        MapSqlParameterSource parameter = params.toJdbcParameter();
        List movimentos = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(MovimentoGaragemDTO.class));
        StringBuilder queryCount = this.filtrosMovimentoGaragem(params, count);
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(queryCount.toString(), (SqlParameterSource)parameter, Long.class);
        return new PageImpl(movimentos, pageable, total.longValue());
    }

    private void consoleLogger(MovimentoGaragemParams params, String sql) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(params.toString());
        }
    }

    private StringBuilder filtrosMovimentoGaragem(MovimentoGaragemParams params, String sql) {
        StringBuilder query = new StringBuilder(sql);
        params.getData().ifPresent(item -> query.append("   AND CAST(MOV_GARAGEM.DATASAIDA AS DATE) = :data "));
        params.getVeiculo().ifPresent(item -> query.append("   AND MOV_GARAGEM.VEICULO = :veiculo "));
        params.getLetraPlaca().ifPresent(item -> query.append("   AND UPPER(VEICULO.LETRAPLACA) LIKE UPPER(:letraPlaca) "));
        params.getNumeroPlaca().ifPresent(item -> query.append("   AND VEICULO.NUMEROPLACA LIKE :numeroPlaca "));
        return query;
    }

    public Optional<MovimentoGaragemDTO> findMovimentoGaragem(MovimentoGaragemParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)MOVIMENTO_GARAGEM));
        query.append(" AND MOV_GARAGEM.NUMERO = :numero ");
        this.consoleLogger(params, query.toString());
        ElotechBeanPropertyRowMapper rowMapper = new ElotechBeanPropertyRowMapper(MovimentoGaragemDTO.class);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)rowMapper).stream().findFirst();
    }
}

