/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AudienciasPublicasDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.AudienciasPublicasParams;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AudienciasPublicasRepository {
    private static final String AUDIENCIAS_PUBLICAS = "db/sql/contab/audienciasPublicas.sql";
    private static final String AUDIENCIAS_PUBLICAS_DETALHES = "db/sql/contab/audienciasPublicas-detalhes.sql";
    private static final String AUDIENCIAS_PUBLICAS_ARQUIVOS = "db/sql/contab/audienciasPublicas-arquivos.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public AudienciasPublicasRepository(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    private Long getCount(String sql, MapSqlParameterSource params) {
        StringBuilder sqlCount = new StringBuilder();
        sqlCount.append("SELECT COUNT(*) AS TOTAL");
        sqlCount.append(" FROM (");
        sqlCount.append(sql);
        sqlCount.append(") X");
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(sqlCount.toString(), (SqlParameterSource)params, Long.class);
    }

    public Page<AudienciasPublicasDTO> findAudienciasPublicas(Pageable pageable, AudienciasPublicasParams params) {
        String sql = FileUtils.readResourceAsString((String)AUDIENCIAS_PUBLICAS);
        sql = sql.replace("$[FILTRO]", params.montaFiltro());
        MapSqlParameterSource jdbcParameters = params.toJdbcParameter();
        String queryOrder = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql, (String)" ORDER BY AUDIENCIAPUBLICA.ID");
        String queryPaginado = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)queryOrder, (String)this.datasourceWrapper.getPlatform());
        List list = this.datasourceWrapper.getJdbcTemplate().query(queryPaginado, (SqlParameterSource)jdbcParameters, (RowMapper)new ElotechBeanPropertyRowMapper(AudienciasPublicasDTO.class));
        return new PageImpl(list, pageable, this.getCount(sql, jdbcParameters).longValue());
    }

    public List<AudienciasPublicasDTO> findAudienciasPublicasDetalhes(AudienciasPublicasParams params) {
        String query = FileUtils.readResourceAsString((String)AUDIENCIAS_PUBLICAS_DETALHES);
        return this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AudienciasPublicasDTO.class));
    }

    public List<ArquivoPessoalDTO> findArquivos(AudienciasPublicasParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)AUDIENCIAS_PUBLICAS_ARQUIVOS).replace("schema_eloarquivo", nomeSchemaEloArquivo);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ArquivoPessoalDTO.class));
    }
}

