/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.mapper;

import br.com.elotech.oxy.adm.patrimonio.client.portal.PatrimonioBemOxy;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioAlienacao;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.PatrimonioBemDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.enums.TipoAlienacao;
import br.com.elotech.portaltransparencia.contabportal.domain.enums.TipoBemEnum;
import java.util.Optional;
import org.springframework.core.convert.converter.Converter;

public class PatrimonioBemOxyToPatrimonioBemDTO
implements Converter<PatrimonioBemOxy, PatrimonioBemDTO> {
    public PatrimonioBemDTO convert(PatrimonioBemOxy source) {
        PatrimonioBemDTO target = new PatrimonioBemDTO();
        target.setEntidade(source.getEntidade());
        target.setChapa(source.getChapa());
        target.setDescricao(source.getDescricao());
        target.setValorAtual(source.getValorAtual());
        target.setValorAquisicao(source.getValorAquisicao());
        target.setLocalAtual(source.getLocalAtual());
        target.setDataAquisicao(source.getDataAquisicao());
        target.setDisplayTipoPatrimonio(source.getDisplayTipo());
        target.setNotaFiscal(String.valueOf(source.getNotaFiscal()));
        target.setNumeroFrota(source.getNumeroFrota());
        target.setTipo(TipoBemEnum.fromOxyValue((String)source.getTipo()).portalName);
        Optional.ofNullable(source.getIncorporacao()).ifPresent(patrimonioAlienacaoOxy -> {
            PatrimonioAlienacao alienacao = new PatrimonioAlienacao();
            alienacao.setIdOxy(patrimonioAlienacaoOxy.getIdOxy());
            alienacao.setTipo(patrimonioAlienacaoOxy.getTipo());
            alienacao.setDescricao(patrimonioAlienacaoOxy.getDescricao());
            if (patrimonioAlienacaoOxy.getTipoAquisicao().equals("PROPRIA")) {
                alienacao.setTipoAquisicao(TipoAlienacao.P);
            } else {
                alienacao.setTipoAquisicao(TipoAlienacao.T);
            }
            target.setTipoIncorporacao(alienacao);
            target.setDisplayTipoIncorporacao(patrimonioAlienacaoOxy.getDescricao());
        });
        if (source.getBaixado() != null && source.getBaixado().booleanValue()) {
            target.setBaixado("S");
        } else {
            target.setBaixado("N");
        }
        return target;
    }
}

