/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.portaltransparencia.contabportal.domain.Fornecedor;
import br.com.elotech.unico.client.dto.PessoaContatoDTO;
import br.com.elotech.unico.client.dto.PessoaDTO;
import java.time.LocalDate;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.hibernate.annotations.Formula;

@Entity
@Table(name="siscop.FORNECEDOR")
public class Fornecedor
implements EloEntity<Long> {
    private static final String FORMULA_NOME = " ( SELECT FR.NOMEANTIGO FROM {SCHEMA_CONTABIL}.FORNECEDORALTERARAZAO FR WHERE FR.FORNECEDOR = FORNECEDOR AND FR.CODIGO = (SELECT MAX(FRR.CODIGO) FROM {SCHEMA_CONTABIL}.FORNECEDORALTERARAZAO FRR WHERE FRR.FORNECEDOR = FR.FORNECEDOR ) ) ";
    private static final String FORMULA_VIGENCIA = " ( SELECT FR.INICIOVIGENCIA FROM {SCHEMA_CONTABIL}.FORNECEDORALTERARAZAO FR WHERE FR.FORNECEDOR = FORNECEDOR AND FR.CODIGO = (SELECT MAX(FRR.CODIGO) FROM {SCHEMA_CONTABIL}.FORNECEDORALTERARAZAO FRR WHERE FRR.FORNECEDOR = FR.FORNECEDOR ) ) ";
    @Id
    @Column(name="FORNECEDOR")
    @NotNull
    private Long id;
    @Column(name="CNPJ", length=15)
    private String cnpj;
    @Column(name="NOME", length=80)
    private String nome;
    @Formula(value=" ( SELECT FR.NOMEANTIGO FROM {SCHEMA_CONTABIL}.FORNECEDORALTERARAZAO FR WHERE FR.FORNECEDOR = FORNECEDOR AND FR.CODIGO = (SELECT MAX(FRR.CODIGO) FROM {SCHEMA_CONTABIL}.FORNECEDORALTERARAZAO FRR WHERE FRR.FORNECEDOR = FR.FORNECEDOR ) ) ")
    private String nomeAntigo;
    @Formula(value=" ( SELECT FR.INICIOVIGENCIA FROM {SCHEMA_CONTABIL}.FORNECEDORALTERARAZAO FR WHERE FR.FORNECEDOR = FORNECEDOR AND FR.CODIGO = (SELECT MAX(FRR.CODIGO) FROM {SCHEMA_CONTABIL}.FORNECEDORALTERARAZAO FRR WHERE FRR.FORNECEDOR = FR.FORNECEDOR ) ) ")
    private LocalDate inicioVigenciaNome;
    private String email;
    private String ddd;
    private String tel;
    private String tipoPessoa;

    public static Fornecedor fromPessoaDTO(PessoaDTO pessoaDTO) {
        Optional<PessoaContatoDTO> contatoPrincipal = pessoaDTO.getContatos().stream().filter(pc -> BooleanUtils.toBoolean((Boolean)pc.getPrincipal())).findFirst();
        Fornecedor fornecedor = new Fornecedor();
        fornecedor.setId(pessoaDTO.getId());
        fornecedor.setNome(pessoaDTO.getNome());
        fornecedor.setCnpj(pessoaDTO.getCnpjCpf());
        fornecedor.setTipoPessoa(pessoaDTO.getTipoPessoa());
        fornecedor.setEmail((String)contatoPrincipal.map(c -> c.getContato().getEmail()).orElse(null));
        fornecedor.setTel((String)contatoPrincipal.map(c -> c.getContato().getTelefoneCelular()).orElse(null));
        return fornecedor;
    }

    @Generated
    public static FornecedorBuilder builder() {
        return new FornecedorBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Fornecedor)) {
            return false;
        }
        Fornecedor other = (Fornecedor)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Fornecedor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getCnpj() {
        return this.cnpj;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getNomeAntigo() {
        return this.nomeAntigo;
    }

    @Generated
    public LocalDate getInicioVigenciaNome() {
        return this.inicioVigenciaNome;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getDdd() {
        return this.ddd;
    }

    @Generated
    public String getTel() {
        return this.tel;
    }

    @Generated
    public String getTipoPessoa() {
        return this.tipoPessoa;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setNomeAntigo(String nomeAntigo) {
        this.nomeAntigo = nomeAntigo;
    }

    @Generated
    public void setInicioVigenciaNome(LocalDate inicioVigenciaNome) {
        this.inicioVigenciaNome = inicioVigenciaNome;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setDdd(String ddd) {
        this.ddd = ddd;
    }

    @Generated
    public void setTel(String tel) {
        this.tel = tel;
    }

    @Generated
    public void setTipoPessoa(String tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    @Generated
    public String toString() {
        return "Fornecedor(id=" + this.getId() + ", cnpj=" + this.getCnpj() + ", nome=" + this.getNome() + ", nomeAntigo=" + this.getNomeAntigo() + ", inicioVigenciaNome=" + String.valueOf(this.getInicioVigenciaNome()) + ", email=" + this.getEmail() + ", ddd=" + this.getDdd() + ", tel=" + this.getTel() + ", tipoPessoa=" + this.getTipoPessoa() + ")";
    }

    @Generated
    public Fornecedor() {
    }

    @Generated
    public Fornecedor(Long id, String cnpj, String nome, String nomeAntigo, LocalDate inicioVigenciaNome, String email, String ddd, String tel, String tipoPessoa) {
        this.id = id;
        this.cnpj = cnpj;
        this.nome = nome;
        this.nomeAntigo = nomeAntigo;
        this.inicioVigenciaNome = inicioVigenciaNome;
        this.email = email;
        this.ddd = ddd;
        this.tel = tel;
        this.tipoPessoa = tipoPessoa;
    }
}

