/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.resource;

import br.com.elotech.portaltransparencia.comprasportal.domain.HomologacaoArquivo;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.HomologacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindHomologacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.service.HomologacaoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/homologacoes"})
public class HomologacaoResource {
    private final HomologacaoService homologacaoService;

    @Autowired
    public HomologacaoResource(HomologacaoService homologacaoService) {
        this.homologacaoService = homologacaoService;
    }

    @GetMapping(params={"entidade", "exercicio", "tipoLicitacao", "licitacao"})
    public ResponseEntity<List<HomologacaoLicitacaoDTO>> findHomologacoes(FindLicitacaoParams params) {
        return ResponseEntity.ok((Object)this.homologacaoService.findHomologacoes(params));
    }

    @GetMapping(value={"/detalhes"}, params={"entidade", "exercicio", "exercicioLicitacao", "tipoLicitacao", "licitacao", "pessoa"})
    public ResponseEntity<HomologacaoLicitacaoDTO> findHomologacao(FindHomologacaoParams params) {
        return ResponseEntity.ok((Object)this.homologacaoService.findHomologacao(params));
    }

    @GetMapping(value={"/arquivos"}, params={"entidade", "exercicio", "exercicioLicitacao", "tipoLicitacao", "licitacao", "pessoa"})
    public ResponseEntity<List<HomologacaoArquivo>> findArquivos(FindHomologacaoParams params) {
        List listMidia = this.homologacaoService.findArquivos(params);
        return ResponseEntity.ok((Object)listMidia);
    }
}

