/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.arquivoportal.service;

import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.core.exception.EloDatabaseException;
import br.com.elotech.portaltransparencia.arquivoportal.domain.Arquivo;
import br.com.elotech.portaltransparencia.arquivoportal.domain.ArquivoContent;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;

@Service
public class FindArquivoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FindArquivoService.class);
    private static final String ARQUIVO_NAO_ENCONTRADO = "Arquivo [%s] n\u00e3o encontrado";
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;
    private final RestTemplateBuilder restTemplateBuilder;

    public String getArquivoNome(Long id) {
        return Optional.ofNullable(this.arquivoStorageFeignClient.findOne(id)).map(ArquivoDTO::getNome).orElseThrow(() -> new IllegalArgumentException(String.format(ARQUIVO_NAO_ENCONTRADO, id)));
    }

    public Arquivo findArquivoPortal(Long id) {
        boolean isArquivoConvertidoS3;
        ArquivoDTO arquivoDto = this.arquivoStorageFeignClient.findOne(id);
        boolean bl = isArquivoConvertidoS3 = Objects.nonNull(arquivoDto) && Objects.nonNull(arquivoDto.getFullPath());
        if (isArquivoConvertidoS3) {
            ArquivoContent arquivoContent = new ArquivoContent();
            arquivoContent.setId(id);
            arquivoContent.setBinary(this.baixarArquivoS3(arquivoDto));
            Arquivo arquivoEntity = new Arquivo();
            arquivoEntity.setId(id);
            arquivoEntity.setContent(arquivoContent);
            arquivoEntity.setNome(arquivoDto.getNome());
            arquivoEntity.setDataCriacao(LocalDate.now());
            return arquivoEntity;
        }
        throw new IllegalArgumentException(String.format(ARQUIVO_NAO_ENCONTRADO, id));
    }

    private byte[] baixarArquivoS3(ArquivoDTO arquivo) {
        ArquivoUrl arquivoUrl = this.arquivoStorageFeignClient.getUrlDownload(arquivo.getFullPath(), arquivo.getNome());
        byte[] contentByte = new byte[]{};
        log.info("Iniciando busca do conte\u00fado do arquivo.");
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_OCTET_STREAM));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplateBuilder.build().exchange(new URI(arquivoUrl.getUrlAssinada()), HttpMethod.GET, entity, byte[].class);
            contentByte = (byte[])response.getBody();
        }
        catch (URISyntaxException | RestClientException e) {
            log.error("Erro na busca do conte\u00fado do arquivo. Erro: {}", (Object)e.getMessage());
        }
        return contentByte;
    }

    protected HttpClient getHttpClient() {
        return HttpClient.newBuilder().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadArquivo(HttpServletResponse response, Long id) throws InterruptedException {
        boolean bl;
        ArquivoDTO arquivo = this.arquivoStorageFeignClient.findOne(id);
        if (Objects.isNull(arquivo)) {
            throw new IllegalArgumentException(String.format(ARQUIVO_NAO_ENCONTRADO, id));
        }
        if (StringUtils.isBlank((CharSequence)arquivo.getFullPath())) {
            return false;
        }
        response.setHeader("Content-Disposition", String.format("inline; filename=\"%s\"", arquivo.getNome()));
        String arquivoUrl = this.arquivoStorageFeignClient.getUrlDownload(arquivo.getFullPath(), arquivo.getNome()).getUrlAssinada();
        HttpResponse<InputStream> httpResponse = this.getHttpClient().send(HttpRequest.newBuilder().header("Accept", "application/octet-stream").uri(URI.create(arquivoUrl)).timeout(Duration.ofMinutes(30L)).GET().build(), HttpResponse.BodyHandlers.ofInputStream());
        InputStream inputStream = httpResponse.body();
        try {
            if (Objects.isNull(inputStream)) {
                throw new EloDatabaseException("Dados do arquivo n\u00e3o encontrados", null);
            }
            if (httpResponse.statusCode() != HttpStatus.OK.value()) {
                String responseBody = new String(inputStream.readAllBytes());
                throw new EloDatabaseException("Erro na busca do conte\u00fado do arquivo: ".concat(responseBody), null);
            }
            httpResponse.headers().firstValueAsLong("Content-Length").ifPresent(arg_0 -> ((HttpServletResponse)response).setContentLengthLong(arg_0));
            response.setContentType(ContentType.fromExtension((String)arquivo.getNome()).getType());
            response.setBufferSize(8192);
            ServletOutputStream outputStream = response.getOutputStream();
            inputStream.transferTo((OutputStream)outputStream);
            outputStream.flush();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                if (Objects.nonNull(inputStream)) {
                    inputStream.close();
                }
                throw throwable;
            }
            catch (EloDatabaseException | InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EloDatabaseException("Erro ao baixar arquivo: ".concat(e.getLocalizedMessage()), (Throwable)e);
            }
        }
        if (Objects.nonNull(inputStream)) {
            inputStream.close();
        }
        return bl;
    }

    @Generated
    public FindArquivoService(ArquivoStorageFeignClient arquivoStorageFeignClient, RestTemplateBuilder restTemplateBuilder) {
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
        this.restTemplateBuilder = restTemplateBuilder;
    }
}

