/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource.params;

import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AjudaCustoParams;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class AjudaCustoParams
implements AiseParams {
    private static final long AJUDA_CUSTO = 11L;
    private static final String LIKE = "%";
    private Long entidade;
    private Long eventoDefinicao;
    private Long matricula;
    private String nome;
    private String exportType;

    public Optional<Long> getMatricula() {
        return Optional.ofNullable(this.matricula);
    }

    public Optional<String> getNome() {
        return Optional.ofNullable(this.nome);
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("entidade", (Object)this.entidade, 2);
        params.addValue("eventoDefinicao", (Object)this.getEventoDefinicao(), 2);
        if (Objects.nonNull(this.matricula)) {
            params.addValue("matricula", (Object)this.matricula, 2);
        }
        if (StringUtils.isNotBlank((String)this.nome)) {
            params.addValue("nome", (Object)LIKE.concat(this.nome).concat(LIKE), 12);
        }
        return params;
    }

    public Long getEventoDefinicao() {
        return Optional.ofNullable(this.eventoDefinicao).orElse(11L);
    }

    public void setEntidadeAise(Long entidadeAise) {
        this.setEntidade(entidadeAise);
    }

    public Long getEntidadeAise() {
        return this.entidade;
    }

    @Generated
    public static AjudaCustoParamsBuilder builder() {
        return new AjudaCustoParamsBuilder();
    }

    @Generated
    public String toString() {
        return "AjudaCustoParams(entidade=" + this.getEntidade() + ", eventoDefinicao=" + this.getEventoDefinicao() + ", matricula=" + String.valueOf(this.getMatricula()) + ", nome=" + String.valueOf(this.getNome()) + ", exportType=" + this.getExportType() + ")";
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setEventoDefinicao(Long eventoDefinicao) {
        this.eventoDefinicao = eventoDefinicao;
    }

    @Generated
    public void setMatricula(Long matricula) {
        this.matricula = matricula;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AjudaCustoParams)) {
            return false;
        }
        AjudaCustoParams other = (AjudaCustoParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$eventoDefinicao = this.getEventoDefinicao();
        Long other$eventoDefinicao = other.getEventoDefinicao();
        if (this$eventoDefinicao == null ? other$eventoDefinicao != null : !((Object)this$eventoDefinicao).equals(other$eventoDefinicao)) {
            return false;
        }
        Optional this$matricula = this.getMatricula();
        Optional other$matricula = other.getMatricula();
        if (this$matricula == null ? other$matricula != null : !((Object)this$matricula).equals(other$matricula)) {
            return false;
        }
        Optional this$nome = this.getNome();
        Optional other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !((Object)this$nome).equals(other$nome)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        return !(this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AjudaCustoParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $eventoDefinicao = this.getEventoDefinicao();
        result = result * 59 + ($eventoDefinicao == null ? 43 : ((Object)$eventoDefinicao).hashCode());
        Optional $matricula = this.getMatricula();
        result = result * 59 + ($matricula == null ? 43 : ((Object)$matricula).hashCode());
        Optional $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : ((Object)$nome).hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        return result;
    }

    @Generated
    public AjudaCustoParams() {
    }

    @Generated
    public AjudaCustoParams(Long entidade, Long eventoDefinicao, Long matricula, String nome, String exportType) {
        this.entidade = entidade;
        this.eventoDefinicao = eventoDefinicao;
        this.matricula = matricula;
        this.nome = nome;
        this.exportType = exportType;
    }
}

