/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.DividaAtivaContribuinteDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.DividaAtivaDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.DividaAtivaRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindDividaAtivaParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.utils.MaskFormatterUtils;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DividaAtivaRepositoryImpl
implements DividaAtivaRepository {
    private static final String DIVIDAS_ATIVAS = "db/sql/aise/dividas-ativas.sql";
    private static final String DIVIDAS_ATIVAS_CONTRIBUINTE = "db/sql/aise/dividas-ativas-contribuinte.sql";
    private static final String TOTAL_DIVIDAS_ATIVAS = "db/sql/aise/dividas-ativas-total.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public DividaAtivaRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public Page<DividaAtivaDTO> findDividasAtivas(FindDividaAtivaParams params, Pageable pageable) {
        String sql = FileUtils.readResourceAsString((String)DIVIDAS_ATIVAS);
        StringBuilder query = this.filtros(params, new StringBuilder(sql));
        sql = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query.toString(), (String)this.datasourceWrapper.getPlatform());
        MapSqlParameterSource parameter = params.toJdbcParameter();
        List dividas = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)parameter, (RowMapper)new ElotechBeanPropertyRowMapper(DividaAtivaDTO.class));
        dividas.forEach(divida -> {
            if (!params.getShowNomeCompleto().booleanValue() && StringUtils.isNotBlank((CharSequence)divida.getNome())) {
                divida.setNome(MaskFormatterUtils.anonimizarNome((String)divida.getNome()));
            }
            if (!params.getShowCpfCnpjCompleto().booleanValue() && StringUtils.isNotBlank((CharSequence)divida.getCnpjCpf())) {
                if (divida.getCnpjCpf().length() == 11) {
                    divida.setCnpjCpf(MaskFormatterUtils.setMaskCpf((String)divida.getCnpjCpf()));
                } else {
                    divida.setCnpjCpf(MaskFormatterUtils.setMaskCnpj((String)divida.getCnpjCpf()));
                }
            }
        });
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(this.getCount(query.toString()).toString(), (SqlParameterSource)parameter, Long.class);
        return new PageImpl(dividas, pageable, total.longValue());
    }

    private StringBuilder filtros(FindDividaAtivaParams params, StringBuilder queryBuilder) {
        String agrupadorIds = SqlUtils.isOracle((String)this.datasourceWrapper.getPlatform()) ? "LISTAGG(P.PESSOA, ',') WITHIN GROUP (ORDER BY P.PESSOA)" : "STRING_AGG(DISTINCT P.PESSOA::text, ',')";
        String sqlComIds = queryBuilder.toString().replace("$[IDS_CONTRIBUINTE]", agrupadorIds);
        StringBuilder filtro = new StringBuilder();
        params.getNomeFiltro().ifPresent(item -> filtro.append(" AND ${db.aise.schema}.tiraacento(LOWER(p.nome)) LIKE ${db.aise.schema}.tiraacento(LOWER(:nomeFiltro)) "));
        if (params.getSomenteAjuizado().booleanValue()) {
            filtro.append(" AND (tdp.SituacaoLegal = 2 OR tdp.idProtesto IS NOT NULL AND tprotesto.datacancelamento IS NULL)");
        }
        String finalSql = sqlComIds.replace("$[FILTRO]", filtro.toString());
        return new StringBuilder(finalSql);
    }

    private StringBuilder getCount(String sql) {
        StringBuilder sqlCount = new StringBuilder();
        sqlCount.append("SELECT COUNT(*) AS TOTAL");
        sqlCount.append(" FROM (");
        sqlCount.append(sql);
        sqlCount.append(") X");
        return sqlCount;
    }

    public List<DividaAtivaContribuinteDTO> findDividasAtivasContribuinte(FindDividaAtivaParams params) {
        String sql = FileUtils.readResourceAsString((String)DIVIDAS_ATIVAS_CONTRIBUINTE);
        StringBuilder query = this.filtros(params, new StringBuilder(sql));
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(DividaAtivaContribuinteDTO.class));
    }

    public Optional<DividaAtivaContribuinteDTO> findValorTotalDividasAtivas(FindDividaAtivaParams params) {
        String sql = FileUtils.readResourceAsString((String)TOTAL_DIVIDAS_ATIVAS);
        StringBuilder query = this.filtros(params, new StringBuilder(sql));
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(DividaAtivaContribuinteDTO.class)).stream().findFirst();
    }
}

