/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.service;

import br.com.elotech.portaltransparencia.contabportal.domain.ConfiguracaoInterface;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class S3Service {
    @Value(value="${amazon.s3.bucket-name}")
    private String s3BucketName;
    private final AmazonS3 s3Client;
    private final EntidadeContabilidadeService entidadeContabilidadeService;

    public S3Service(AmazonS3 s3Client, EntidadeContabilidadeService entidadeContabilidadeService) {
        this.s3Client = s3Client;
        this.entidadeContabilidadeService = entidadeContabilidadeService;
    }

    public String uploadToS3(MultipartFile file, ConfiguracaoInterface configuracao) throws IOException {
        if (configuracao.getUrlImagem() != null) {
            this.removeFromS3(this.getKeyByUrl(configuracao.getUrlImagem()));
        }
        if (file != null) {
            Optional entidadePrincipal = this.entidadeContabilidadeService.getEntidadePrincipal();
            StringBuilder key = new StringBuilder();
            if (entidadePrincipal.isPresent()) {
                key.append(((Entidade)entidadePrincipal.get()).getCnpj());
                key.append('_');
                key.append(UUID.randomUUID());
            }
            PutObjectRequest request = new PutObjectRequest(this.s3BucketName, key.toString(), file.getInputStream(), new ObjectMetadata()).withCannedAcl(CannedAccessControlList.PublicRead);
            this.s3Client.putObject(request);
            return this.s3Client.getUrl(this.s3BucketName, key.toString()).toString();
        }
        return "";
    }

    public String getKeyByUrl(String urlAtual) {
        String[] split = urlAtual.split("/");
        return split[split.length - 1];
    }

    public void removeFromS3(String key) throws IOException {
        DeleteObjectRequest request = new DeleteObjectRequest(this.s3BucketName, key);
        this.s3Client.deleteObject(request);
    }
}

