/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.portaltransparencia.admportal.repository.PublicacaoRepository;
import br.com.elotech.portaltransparencia.admportal.repository.PublicacaoSubGrupoRepository;
import br.com.elotech.portaltransparencia.admportal.service.PortalAdminArquivoService;
import br.com.elotech.portaltransparencia.contabportal.domain.ArquivoContab;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.Publicacao;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoGrupo;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoGrupoEntidade;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoGrupoEntidadePK;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoSubGrupo;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoSubGrupoExercicio;
import br.com.elotech.portaltransparencia.contabportal.repository.PublicacaoGrupoEntidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.PublicacaoSubGrupoExercicioRepository;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PublicacaoService
extends CrudService<Publicacao, Long> {
    private final PortalAdminArquivoService arquivoService;
    private final PublicacaoSubGrupoRepository subGrupoRepository;
    private final PublicacaoSubGrupoExercicioRepository subGrupoExercicioRepository;
    private final PublicacaoGrupoEntidadeRepository grupoEntidadeRepository;
    private final PublicacaoRepository publicacaoRepository;
    private static final Long ORDEM_SUBSEQUENTE = 1L;

    protected void beforeInsert(Publicacao entity) {
        if (Objects.isNull(entity.getGrupo().getId())) {
            PublicacaoSubGrupoExercicio grupo = entity.getGrupo();
            PublicacaoSubGrupo subGrupoRelatorio = grupo.getSubGrupoRelatorio();
            Long entidade = entity.getEntidade();
            grupo.setEntidade(entidade);
            grupo.setExercicio(entity.getExercicio());
            grupo.setSubGrupoRelatorio((PublicacaoSubGrupo)this.subGrupoRepository.findOne((Object)subGrupoRelatorio.getId()));
            this.subGrupoExercicioRepository.findFirstBySubGrupoRelatorioId(subGrupoRelatorio.getId()).ifPresent(subGrupoExercicio -> {
                grupo.setTipoPeriodo(subGrupoExercicio.getTipoPeriodo());
                grupo.setMostraWeb(subGrupoExercicio.getMostraWeb());
                Long idGrupoRelatorio = subGrupoExercicio.getSubGrupoRelatorio().getIdGrupoRelatorio();
                if (this.grupoEntidadeRepository.findByIdEntidadeIdAndIdGrupoId(entidade, idGrupoRelatorio).isEmpty()) {
                    PublicacaoGrupoEntidade publicacaoGrupoEntidade = new PublicacaoGrupoEntidade();
                    publicacaoGrupoEntidade.setId(new PublicacaoGrupoEntidadePK(Entidade.of((Long)entidade), PublicacaoGrupo.of((Long)idGrupoRelatorio)));
                    this.grupoEntidadeRepository.findByIdGrupoId(idGrupoRelatorio).ifPresent(grupoEntidade -> {
                        publicacaoGrupoEntidade.getId().setGrupo(grupoEntidade.getId().getGrupo());
                        publicacaoGrupoEntidade.setMostraAcessoRapido(grupoEntidade.getMostraAcessoRapido());
                        publicacaoGrupoEntidade.setMostraWeb(grupoEntidade.getMostraWeb());
                    });
                    this.grupoEntidadeRepository.saveAndFlush((Object)publicacaoGrupoEntidade);
                }
            });
            this.getEm().clear();
            PublicacaoSubGrupoExercicio subGrupoExercicio2 = (PublicacaoSubGrupoExercicio)this.subGrupoExercicioRepository.saveAndFlush((Object)grupo);
            entity.setGrupo(subGrupoExercicio2);
        }
        if (Objects.isNull(entity.getOrdem()) && Objects.nonNull(entity.getGrupo().getSubGrupoRelatorio())) {
            entity.setOrdem(this.findLastOrdemBySubGrupo(entity.getGrupo().getSubGrupoRelatorio().getId()));
        }
    }

    @Transactional
    public Publicacao adicionarArquivoPublicacao(Long id, MultipartFile file) {
        Publicacao publicacao = (Publicacao)this.findOne((Serializable)id);
        publicacao.setArquivo(this.arquivoService.adicionarArquivo(file));
        return (Publicacao)this.save((EloEntity)publicacao, null);
    }

    @Transactional
    public Publicacao removerArquivoPublicacao(Long id) {
        Publicacao publicacao = (Publicacao)this.findOne((Serializable)id);
        ArquivoContab arquivo = publicacao.getArquivo();
        publicacao.setArquivo(null);
        this.arquivoService.deletarArquivo(arquivo);
        return publicacao;
    }

    public Long findLastOrdemBySubGrupo(Long subGrupoId) {
        return this.publicacaoRepository.findLastOrdemBySubgrupo(subGrupoId) + ORDEM_SUBSEQUENTE;
    }

    @Generated
    public PublicacaoService(PortalAdminArquivoService arquivoService, PublicacaoSubGrupoRepository subGrupoRepository, PublicacaoSubGrupoExercicioRepository subGrupoExercicioRepository, PublicacaoGrupoEntidadeRepository grupoEntidadeRepository, PublicacaoRepository publicacaoRepository) {
        this.arquivoService = arquivoService;
        this.subGrupoRepository = subGrupoRepository;
        this.subGrupoExercicioRepository = subGrupoExercicioRepository;
        this.grupoEntidadeRepository = grupoEntidadeRepository;
        this.publicacaoRepository = publicacaoRepository;
    }
}

