SELECT B.DATA, (CASE C.DEBCRED WHEN 'D' THEN C.VALOR * -1 ELSE C.VALOR END) AS VALOR, 
	   COALESCE(CB.DESCRICAO, P.DESCRICAO) AS LOCAL, C.CONTA, CC.IDCONTACORRENTE, C.NROLANCAMENTO,
	   (CASE WHEN B.COMPLEMENTO <> '' THEN B.COMPLEMENTO ELSE B.NRODOCUMENTOORIGEM END) AS COMPHIST
  FROM ${db.contabilidade.schema}.EVENTOSLANCADOSCONTA C
  LEFT OUTER JOIN ${db.contabilidade.schema}.EVENTOSLANCADOS B
    ON B.ENTIDADE = C.ENTIDADE
   AND B.EXERCICIO = C.EXERCICIO
   AND B.TIPOEVENTO = C.TIPOEVENTO
   AND B.GRUPOEVENTO = C.GRUPOEVENTO
   AND B.EVENTO = C.EVENTO
   AND B.NROLANCAMENTO = C.NROLANCAMENTO
  LEFT JOIN ${db.contabilidade.schema}.EVENTOSLANCADOSCONTA C1
    ON C1.ENTIDADE = C.ENTIDADE
   AND C1.EXERCICIO = C.EXERCICIO
   AND C1.TIPOEVENTO = C.TIPOEVENTO
   AND C1.GRUPOEVENTO = C.GRUPOEVENTO
   AND C1.EVENTO = C.EVENTO
   AND C1.NROLANCAMENTO = C.NROLANCAMENTO
   AND C1.SEQUENCIA = C.SEQUENCIA
   AND C1.DEBCRED <> C.DEBCRED
  LEFT JOIN ${db.contabilidade.schema}.CONTACORRENTE CC
    ON CC.ENTIDADE = C1.ENTIDADE
   AND CC.IDCONTACORRENTE = C1.IDCONTACORRENTE
  LEFT JOIN ${db.contabilidade.schema}.CONTABANCARIAVINCULO CV
    ON CV.ENTIDADE = CC.ENTIDADE
   AND CV.ID = CC.IDCONTABANCARIAVINCULO
  LEFT JOIN ${db.contabilidade.schema}.CONTABANCARIA CB
    ON CB.ENTIDADE = CV.ENTIDADE
   AND CB.REDUZIDO = CV.REDUZIDO
  LEFT JOIN ${db.contabilidade.schema}.PLANO P 
    ON P.ENTIDADE = C.ENTIDADE 
   AND P.EXERCICIO = C.EXERCICIO 
   AND P.CONTA  = C.CONTA  
 WHERE C.ENTIDADE = :entidade
   AND C.EXERCICIO = :exercicio
