SELECT SUBSTR(R.RECEITA,1, R.INICIO+TAMANHO-1) AS RECEITA, PR.DESCRICAO,
       COALESCE(SUM(R.VALORORCADO),0) AS VALORORCADO,
       (COALESCE(SUM(R.VALORORCADO),0) +
       COALESCE(SUM(
          (SELECT SUM(RECM.VALORCORRECAOORCADO) 
             FROM ${db.contabilidade.schema}.RECEITAMENSAL RECM
            WHERE R.ENTIDADE = RECM.ENTIDADE
              AND R.EXERCICIO = RECM.EXERCICIO
              AND R.RECEITA = RECM.RECEITA
              AND R.FONTERECURSO = RECM.FONTERECURSO
              AND R.IDTIPOOPERACAORECEITA = RECM.IDTIPOOPERACAORECEITA
              AND RECM.MES <= :mesDiasRetroativos)),0)) AS VALORATUALIZADO,
       COALESCE(SUM(
          (SELECT SUM(RD.VALORARRECADADO - RD.VALORESTARRECADADO - RD.VALORDEVOLUCAO + RD.VALORESTDEVOLUCAO)
             FROM ${db.contabilidade.schema}.RECEITADIARIA RD
            WHERE R.ENTIDADE = RD.ENTIDADE
              AND R.EXERCICIO = RD.EXERCICIO
              AND R.RECEITA = RD.RECEITA
              AND R.FONTERECURSO = RD.FONTERECURSO
              AND R.IDTIPOOPERACAORECEITA = RD.IDTIPOOPERACAORECEITA
              AND RD.DATA <= :diasRetroativo)),0) AS VALORARRECADADO
  FROM ${db.contabilidade.schema}.RECEITA R
  LEFT JOIN ${db.contabilidade.schema}.ORCPARAMETRORECEITA PR
    ON R.ENTIDADE = PR.ENTIDADE
   AND R.EXERCICIO = PR.EXERCICIO
   AND R.MODELORECEITA = PR.MODELORECEITA
   AND R.TIPO = PR.TIPO
   AND R.NIVEL = PR.ORDEM
   AND R.RECEITA = PR.CODIGO
 WHERE R.ENTIDADE = :entidade
   AND R.EXERCICIO = :exercicio
   AND R.RECEITA = :receita
       $[FILTRO]
 GROUP BY SUBSTR(R.RECEITA,1, R.INICIO+TAMANHO-1), PR.DESCRICAO, R.NIVEL, R.INICIO, R.TAMANHO, R.MOVSN
 ORDER BY SUBSTR(R.RECEITA,1, R.INICIO+TAMANHO-1), PR.DESCRICAO