SELECT E.ENTIDADE,
       E.EXERCICIO,
       E.NOEXTRAORCAMENTARIO,
       E.FORNECEDOR,
       F.NOME AS NOMEFORNECEDOR,
       CASE
	    	WHEN F.TIPOPESSOA = 'F'
	    	THEN '**' || SUBSTR(F.CNPJ,3,5) || '****'
	    	ELSE F.CNPJ
	    END AS CNPJCPF,
       E.CONTACREDITO,
       E.CONTADEBITO,
       E.DATA,
       E.VENCIMENTO,
       E.VALOR,
       E.VALORPAGAMENTO,
       E.VALORESTPAGAMENTO,
       E.VALORESTORNO,
       E.DATADOCUMENTO,
       E.SALDOANTERIOR,
       E.COMPLEMENTO,
       E.ESTADO,
       E.CLASSIFICACAO,
       E.UNIDADEORCAMENTARIA,
       E.FONTERECURSO,
       E.EXTRAORIGINAL,
       E.EXTRAANTERIOR,
       E.NOPROCESSO,
       E.ANOPROCESSO,
       E.IDNOTAEXTRA,
       E.BANCO,
       E.AGENCIA,
       E.CONTA,
       E.IDCONTACORRENTECRED,
       E.IDCONTACORRENTEDEB,
       H.DESCRICAO AS HISTORICO,
       R.DESCRICAO AS DESCRICAOFONTE,
       E.NOEXTRAORCAMENTARIO || '/' || E.EXERCICIO  AS NONOTAEXERCICIO,
       CASE
	    	WHEN F.TIPOPESSOA = 'F'
	    	THEN '**' || SUBSTR(F.CNPJ,3,5) || '****'
	    	ELSE F.CNPJ
	    END || ' - ' || F.NOME AS CNPJNOMEFORNECEDOR
  FROM ${db.contabilidade.schema}.EXTRAORCAMENTARIO E
  JOIN ${db.contabilidade.schema}.FORNECEDOR F
    ON F.FORNECEDOR = E.FORNECEDOR
  LEFT JOIN ${db.contabilidade.schema}.HISTORICO H
    ON H.HISTORICO = E.HISTORICO
  LEFT JOIN ${db.contabilidade.schema}.FONTERECURSO R
    ON R.FONTERECURSO = E.FONTERECURSO
 WHERE E.ENTIDADE = :entidade
   AND E.EXERCICIO = :exercicio
