SELECT row_number() OVER (ORDER BY XX.FONTERECURSO, XX.DATA, XX.EMPENHO, XX.NOLIQUIDACAO, XX.EXERCICIO) AS ORDEMFONTERECURSO, XX.*
  FROM (
SELECT DISTINCT
       E.DATA AS DATAEMPENHO,
       SUBSTR(DESP.PROGRAMATICA,ORG.POSICAO,ORG.TAMANHO) AS ORGAO,
       (SELECT PARAM.DESCRICAO FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA PARAM
         WHERE PARAM.ENTIDADE = DESP.ENTIDADE
           AND PARAM.EXERCICIO = DESP.EXERCICIO
           AND PARAM.MODELODESPESA = DESP.MODELODESPESA
           AND PARAM.TIPO = ORG.TIPO
           AND PARAM.ORDEM = ORG.ORDEM
           AND PARAM.CODIGO = SUBSTR(DESP.PROGRAMATICA,ORG.POSICAO,ORG.TAMANHO)) AS DESCRICAOORGAO,
       SUBSTR(DESP.PROGRAMATICA,UNID.POSICAO+ORG.TAMANHO,UNID.TAMANHO-ORG.TAMANHO) AS UNIDADE,
       (SELECT PARAM.DESCRICAO FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA PARAM
         WHERE PARAM.ENTIDADE = DESP.ENTIDADE
           AND PARAM.EXERCICIO = DESP.EXERCICIO
           AND PARAM.MODELODESPESA = DESP.MODELODESPESA
           AND PARAM.TIPO = UNID.TIPO
           AND PARAM.ORDEM = UNID.ORDEM
           AND PARAM.CODIGO = SUBSTR(DESP.PROGRAMATICA,UNID.POSICAO,UNID.TAMANHO)) AS DESCRICAOUNIDADE,
       SUBSTR(DESP.PROGRAMATICA,FUNCAO.POSICAO,FUNCAO.TAMANHO) AS FUNCAO,
       (SELECT PARAM.DESCRICAO FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA PARAM
         WHERE PARAM.ENTIDADE = DESP.ENTIDADE
           AND PARAM.EXERCICIO = DESP.EXERCICIO
           AND PARAM.MODELODESPESA = DESP.MODELODESPESA
           AND PARAM.TIPO = FUNCAO.TIPO
           AND PARAM.ORDEM = FUNCAO.ORDEM
           AND PARAM.CODIGO = SUBSTR(DESP.PROGRAMATICA,FUNCAO.POSICAO,FUNCAO.TAMANHO)) AS DESCRICAOFUNCAO,
       SUBSTR(DESP.PROGRAMATICA,SUBFUNCAO.POSICAO,SUBFUNCAO.TAMANHO) AS SUBFUNCAO,
       (SELECT PARAM.DESCRICAO FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA PARAM
         WHERE PARAM.ENTIDADE = DESP.ENTIDADE
           AND PARAM.EXERCICIO = DESP.EXERCICIO
           AND PARAM.MODELODESPESA = DESP.MODELODESPESA
           AND PARAM.TIPO = SUBFUNCAO.TIPO
           AND PARAM.ORDEM = SUBFUNCAO.ORDEM
           AND PARAM.CODIGO = SUBSTR(DESP.PROGRAMATICA,SUBFUNCAO.POSICAO,SUBFUNCAO.TAMANHO)) AS DESCRICAOSUBFUNCAO,
       SUBSTR(DESP.PROGRAMATICA,PROG.POSICAO,PROG.TAMANHO) AS PROGRAMA,
       (SELECT PARAM.DESCRICAO FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA PARAM
         WHERE PARAM.ENTIDADE = DESP.ENTIDADE
           AND PARAM.EXERCICIO = DESP.EXERCICIO
           AND PARAM.MODELODESPESA = DESP.MODELODESPESA
           AND PARAM.TIPO = PROG.TIPO
           AND PARAM.ORDEM = PROG.ORDEM
           AND PARAM.CODIGO = SUBSTR(DESP.PROGRAMATICA,PROG.POSICAO,PROG.TAMANHO)) AS DESCRICAOPROGRAMA,
       SUBSTR(DESP.PROGRAMATICA,PROJ.POSICAO,PROJ.TAMANHO) AS PROJETO,
       (SELECT PARAM.DESCRICAO FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA PARAM
         WHERE PARAM.ENTIDADE = DESP.ENTIDADE
           AND PARAM.EXERCICIO = DESP.EXERCICIO
           AND PARAM.MODELODESPESA = DESP.MODELODESPESA
           AND PARAM.TIPO = PROJ.TIPO
           AND PARAM.ORDEM = PROJ.ORDEM
           AND PARAM.CODIGO = SUBSTR(DESP.PROGRAMATICA,PROJ.POSICAO,PROJ.TAMANHO)) AS DESCRICAOPROJETO,
       SUBSTR(DESP.PROGRAMATICA,ELEM.POSICAO,ELEM.TAMANHO) AS ELEMENTO,
       (SELECT PARAM.DESCRICAO FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA PARAM
         WHERE PARAM.ENTIDADE = DESP.ENTIDADE
           AND PARAM.EXERCICIO = DESP.EXERCICIO
           AND PARAM.MODELODESPESA = DESP.MODELODESPESA
           AND PARAM.TIPO = ELEM.TIPO
           AND PARAM.ORDEM = ELEM.ORDEM
           AND PARAM.CODIGO = SUBSTR(DESP.PROGRAMATICA,ELEM.POSICAO,ELEM.TAMANHO)) AS DESCRICAOELEMENTO,
       E.DESDOBRADESP,     
       (SELECT DESD.DESCRICAO FROM ${db.contabilidade.schema}.DESDOBRADESP DESD
         WHERE DESD.ENTIDADE = DESP.ENTIDADE
           AND DESD.EXERCICIO = DESP.EXERCICIO
           AND DESD.DESPESA = SUBSTR(DESP.PROGRAMATICA,ELEM.POSICAO,6)
           AND DESD.DESDOBRAMENTO = E.DESDOBRADESP
           AND DESD.SUBDESDOBRAMENTO = '00') AS DESCRICAODESDOBRAMENTO,
       E.SUBDESDOBRAMENTO,     
       (SELECT DESD.DESCRICAO FROM ${db.contabilidade.schema}.DESDOBRADESP DESD
         WHERE DESD.ENTIDADE = DESP.ENTIDADE
           AND DESD.EXERCICIO = DESP.EXERCICIO
           AND DESD.DESPESA = SUBSTR(DESP.PROGRAMATICA,ELEM.POSICAO,6)
           AND DESD.DESDOBRAMENTO = E.DESDOBRADESP
           AND DESD.SUBDESDOBRAMENTO = E.SUBDESDOBRAMENTO) AS DESCRICAOSUBDESDOBRAMENTO,           
       FR.FONTERECURSO||' - '||FR.DESCRICAO AS FONTERECURSO,
       P.DATA,
       L.EXERCICIO AS EXERCICIOLIQUIDACAO,
       L.NOLIQUIDACAO,
       LIQ.DATA AS DATALIQUIDACAO,
       LIQ.DATAVENCIMENTO,
       E.ENTIDADE,
       E.EXERCICIO,
       E.EMPENHO,
       E.EMPENHO||'/'||E.EXERCICIO AS EMPENHOEXERCICIO,
       TL.DESCRICAO AS TIPOLICITACAO,
       E.NOLICITACAO||'/'||E.ANOLICITACAO AS LICITACAO,
       CASE WHEN F.TIPOPESSOA = 'F' THEN '****' || SUBSTR(F.CNPJ, 5, 3) || '****' || ' - ' || (${db.contabilidade.schema}.BUSCARAZAOSOCIALFORNECEDOR(F.FORNECEDOR, P.DATA))
            ELSE SUBSTR(F.CNPJ,1,2) || '.' || SUBSTR(F.CNPJ,3,3) || '.' || SUBSTR(F.CNPJ,6,3) || '/' || SUBSTR(F.CNPJ,9,4) || '-' || SUBSTR(F.CNPJ,13,2) || ' - ' || (${db.contabilidade.schema}.BUSCARAZAOSOCIALFORNECEDOR(F.FORNECEDOR, P.DATA))
       END AS FORNECEDOR,
       L.VALOR,
       L.VALOR AS SALDO,
       E.NOPROCESSO||'/'||E.ANOPROCESSO AS PROCESSO,       
	   CASE WHEN COALESCE(IC.TIPOCONTRATO,E.TIPOCONTRATOAPICE) = 'CP' THEN 'fornecimentoBens'
	        WHEN COALESCE(IC.TIPOCONTRATO,E.TIPOCONTRATOAPICE) = 'LC' THEN 'locacoes'
	        WHEN COALESCE(IC.TIPOCONTRATO,E.TIPOCONTRATOAPICE) = 'PS' THEN 'prestacaoServicos'
	        WHEN COALESCE(IC.TIPOCONTRATO,E.TIPOCONTRATOAPICE) = 'OE' THEN 'obras'
	        ELSE 'outros'
       END AS TIPOCONTRATO,
	   CASE WHEN IC.TIPOCONTRATOCONTABIL = '04' THEN 'fornecimentoBens'
	        ELSE 'outros'
	   END AS TIPOCONTRATOCONTABIL,
       
	   COALESCE(CP.OBSERVACAO,'') AS OBSERVACAO,
       L.VALOR + COALESCE((SELECT  SUM(RETLIQ.VALOR)
                             FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RETLIQ
                             JOIN ${db.contabilidade.schema}.PARAMETROS PARAM
                               ON  PARAM.ENTIDADE   = RETLIQ.ENTIDADE
                              AND  PARAM. EXERCICIO = RETLIQ.EXERCICIO
                              AND  PARAM.MODULO     = '3'
                              AND  PARAM.CODIGO     = 18
                              AND  PARAM.VALOR      = 'L'
                            WHERE  RETLIQ.ENTIDADE         = L.ENTIDADE
                            AND    RETLIQ.EXERCICIO        = L.EXERCICIO
                            AND    RETLIQ.NOLIQUIDACAO     = L.NOLIQUIDACAO
                            AND    RETLIQ.TIPODOCORIGEM    = 'E'
                            AND    RETLIQ.ANODOCORIGEM     = L.ANODOCORIGEM
                            AND    RETLIQ.NODOCORIGEM      = L.NODOCORIGEM
                            AND    RETLIQ.UNIDADEDOCORIGEM = L.UNIDADEDOCORIGEM),0) + COALESCE((SELECT  SUM(RETPAG.VALOR)
                                                                                                  FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_RETENCAO RETPAG
                                                                                                  JOIN ${db.contabilidade.schema}.PARAMETROS PARAM
                                                                                                    ON   PARAM.ENTIDADE   = RETPAG.ENTIDADE
                                                                                                   AND   PARAM. EXERCICIO = RETPAG.EXERCICIO
                                                                                                   AND   PARAM.MODULO     = '3'
                                                                                                   AND   PARAM.CODIGO     = 18
                                                                                                   AND   PARAM.VALOR      = 'P'
                                                                                                 WHERE  RETPAG.ENTIDADE   = L.ENTIDADE
                                                                                                 AND    RETPAG.EXERCICIO  = L.EXERCICIO
                                                                                                 AND    RETPAG.NOORDEM    = L.NOORDEM
                                                                                                 AND    RETPAG.SEQUENCIA  = L.SEQUENCIA ),0)  AS VALORPARAMETRO
  FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO L
 INNER JOIN ${db.contabilidade.schema}.PAGAMENTO P
    ON L.ENTIDADE = P.ENTIDADE
   AND L.EXERCICIO = P.ANOORDEMPAGAMENTO
   AND L.NOORDEM = P.NOORDEMPAGAMENTO
   AND P.ESTORNO = 'N'
  LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO E
    ON L.ENTIDADE = E.ENTIDADE
   AND L.ANODOCORIGEM = E.EXERCICIO
   AND L.NODOCORIGEM = E.EMPENHO
   AND L.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA
   AND E.CONTABILIZADO = 'S'
  LEFT OUTER JOIN ${db.contabilidade.schema}.DESPESA DESP
    ON E.ENTIDADE = DESP.ENTIDADE
   AND E.EXERCICIO = DESP.EXERCICIO
   AND E.PROGRAMATICA = DESP.PROGRAMATICA
   AND E.FONTERECURSO = DESP.FONTERECURSO   
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA ORG
    ON DESP.MODELODESPESA = ORG.MODELODESPESA
   AND ORG.TIPO = 'P'
   AND ORG.ORDEM = 1   
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA UNID
    ON DESP.MODELODESPESA = UNID.MODELODESPESA
   AND UNID.TIPO = 'C'
   AND UNID.ORDEM = 2  
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA FUNCAO
    ON DESP.MODELODESPESA = FUNCAO.MODELODESPESA
   AND FUNCAO.TIPO = 'P'
   AND FUNCAO.ORDEM = 3
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA SUBFUNCAO
    ON DESP.MODELODESPESA = SUBFUNCAO.MODELODESPESA
   AND SUBFUNCAO.TIPO = 'P'
   AND SUBFUNCAO.ORDEM = 4
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA PROG
    ON DESP.MODELODESPESA = PROG.MODELODESPESA
   AND PROG.TIPO = 'P'
   AND PROG.ORDEM = 5
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA PROJ
    ON DESP.MODELODESPESA = PROJ.MODELODESPESA
   AND PROJ.TIPO = 'P'
   AND PROJ.ORDEM = 6
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA ELEM
    ON DESP.MODELODESPESA = ELEM.MODELODESPESA
   AND ELEM.TIPO = 'C'
   AND ELEM.ORDEM = 7
  LEFT OUTER JOIN ${db.contabilidade.schema}.FONTERECURSO FR
    ON E.FONTERECURSO = FR.FONTERECURSO     
  LEFT JOIN ${db.contabilidade.schema}.FONTERECURSOPADRAO FRP
    ON FR.CODIGOFONTEPADRAO = FRP.CODIGO
  LEFT OUTER JOIN ${db.contabilidade.schema}.TIPOSLICITACAO TL
    ON E.TIPOLICITACAO = TL.TIPOLICITACAO
  LEFT OUTER JOIN ${db.contabilidade.schema}.FORNECEDOR F
    ON E.FORNECEDOR = F.FORNECEDOR
  LEFT JOIN ${db.contabilidade.schema}.LIQUIDACAO LIQ
    ON LIQ.ENTIDADE         = L.ENTIDADE
   AND LIQ.EXERCICIO        = L.EXERCICIOLIQ
   AND LIQ.TIPODOCORIGEM    = L.TIPODOCORIGEM
   AND LIQ.ANODOCORIGEM     = L.ANODOCORIGEM
   AND LIQ.NODOCORIGEM      = L.NODOCORIGEM
   AND LIQ.UNIDADEDOCORIGEM = L.UNIDADEDOCORIGEM
   AND LIQ.NOLIQUIDACAO     = L.NOLIQUIDACAO
  LEFT JOIN ${db.contabilidade.schema}.INTEGRACAOCLCONTRATO IC
    ON IC.ENTIDADE = E.ENTIDADE
   AND IC.ID       = E.IDCONTRATO
  LEFT OUTER JOIN ${db.contabilidade.schema}.ITEMCENTRALPAGAMENTOS ICP
    ON ICP.ENTIDADE            = L.ENTIDADE
   AND ICP.ANOORDEM            = L.EXERCICIO
   AND ICP.NOORDEM             = L.NOORDEM
   AND ICP.ANODOCORIGEM        = L.ANODOCORIGEM
   AND ICP.NRDOCORIGEM         = L.NODOCORIGEM
   AND ICP.EXERCICIOLIQUIDACAO = L.EXERCICIOLIQ
   AND ICP.NRLIQUIDACAO        = L.NOLIQUIDACAO
  LEFT JOIN ${db.contabilidade.schema}.CENTRALPAGAMENTOS CP
    ON CP.ENTIDADE   = ICP.ENTIDADE
   AND CP.EXERCICIO  = ICP.EXERCICIO
   AND CP.LANCAMENTO = ICP.LANCAMENTO
       $[FILTRO] AND COALESCE(E.EXIBICAOBASICA,'N') = 'N') XX $[WHERE]
