SELECT A.ID as PESSOA,
       A.TIPOPESSOA,
       A.NOME,
       A.NOMEFANTASIA,
       A.FORNECEDOR,
       A.SITUACAO,
       CASE
           WHEN A.SITUACAO = 0 THEN 'Habilitado'
           WHEN A.SITUACAO = 1 THEN 'Inabilitado'
           WHEN A.SITUACAO = 2 THEN 'Inadimplente'
           WHEN A.SITUACAO = 3 THEN 'Inabilitado Rescisão'
           WHEN A.SITUACAO = 4 THEN 'Inabilitado Suspenso'
           WHEN A.SITUACAO = 5 THEN 'Inabilitado Outros'
           WHEN A.SITUACAO = 6 THEN 'Suspenso por Prazo Indeterminado'
       END AS SITUACAODESCRICAO,
       A.DATAINISUSPENSAO AS DATAINISUSPENSAO,
       A.DATAINISUSPENSAO AS DATARESTRICAOINICIO,
       A.DATAFIMSUSPENSAO AS DATAFINSUSPENSAO,
       A.DATAFIMSUSPENSAO AS DATARESTRICAOFIM,
       CASE
         WHEN A.TIPOPESSOA = 'F' THEN
           '****' || SUBSTR(A.CNPJ_CPF, 5, 3) || '****'
           ELSE SUBSTR(A.CNPJ_CPF,1,2) || '.' || SUBSTR(A.CNPJ_CPF,3,3) || '.' || SUBSTR(A.CNPJ_CPF,6,3) || '/' || SUBSTR(A.CNPJ_CPF,9,4) || '-' || SUBSTR(A.CNPJ_CPF,13,2)
       END AS CNPJ_CPF,
       A.OBSERVACAO
  FROM %s.PESSOA A