SELECT DISTINCT CL.ENTIDADE, 
       CL.EXERCICIO, 
       PD.PESSOA,
       T.DESCRICAO MODALIDADE, 
       CL.NUMEROLICITACAO LICITACAO,
       CL.DATAABERTURA,
       CC.NUMEROCONTRATO,
       ARQ.IDARQUIVO, 
       CASE WHEN ARQ.NOMEARQUIVO IS NULL THEN ELOARQ.NOME ELSE ARQ.NOMEARQUIVO END AS NOMEARQUIVO
  FROM ${db.compras.schema}.CLFORNECEDORDOCUMENTACAO PD
  JOIN ${db.compras.schema}.CLLICITACAO CL
    ON CL.ENTIDADE = PD.ENTIDADE
   AND CL.EXERCICIO = PD.EXERCICIO
   AND CL.LICITACAO = PD.LICITACAO
   AND CL.TIPOLICITACAO = PD.TIPOLICITACAO
  LEFT JOIN ${db.compras.schema}.CLCONTRATO CC
    ON CC.PESSOA = PD.PESSOA
   AND CC.EXERCICIOLICITACAO = CL.EXERCICIO
   AND CC.ENTIDADELICITACAO = CL.ENTIDADE
   AND CC.LICITACAO = CL.LICITACAO
   AND CC.TIPOLICITACAO = CL.TIPOLICITACAO
  LEFT JOIN ${db.compras.schema}.CLTIPOLICITACAO T
    ON T.TIPOLICITACAO = CL.TIPOLICITACAO
  LEFT JOIN ${db.compras.schema}.ARQUIVO ARQ
    ON ARQ.ID = CC.IDARQUIVO
   AND COALESCE(ARQ.ARQUIVOSIGILOSO,'N') <> 'S'
  LEFT JOIN eloarquivo.ARQUIVO ELOARQ 
    ON ELOARQ.ID = ARQ.IDARQUIVO 
  LEFT JOIN eloarquivo.ARQUIVO_CONTENT AC 
    ON AC.ID = ARQ.IDARQUIVO
 WHERE PD.ENTIDADE = :entidade
   AND PD.PESSOA = :pessoa
