SELECT DESCRICAO, RECEITA,
       SUM(VALORRECEITA) AS VALORLANCADO,
       SUM(VALORRENUNCIA) AS VALORRENUNCIA,
       SUM(TOTALLANCADO) AS VALORLANCADOLIQUIDO,
       SUM(TOTALPAGO) AS VALORPAGO,
       SUM(TOTALCANCELADO) AS VALORCANCELADO,
       SUM(OUTRASBAIXAS) AS OUTRASBAIXAS,
       SUM(VALORLANCADOPERIODO) AS VALORLANCADOPERIODO,
       SUM(VALORINADIMPLENTE) AS VALORINADIMPLENTE,
       COUNT(DISTINCT CADASTROGERAL) TOTALCADASTRO,
       COUNT(DISTINCT CADASTROGERAL) TOTALCADASTRO,
       COUNT(DISTINCT CASE WHEN VALORRENUNCIA > 0 THEN CADASTROGERAL ELSE NULL END) AS TOTALCADASTRORENUNCIA,
       COUNT(DISTINCT CASE WHEN PAGO > 0 THEN CADASTROGERAL ELSE NULL END) AS TOTALCADASTROPAGO,
       COUNT(DISTINCT CASE WHEN VALORINADIMPLENTE > 0 THEN CADASTROGERAL ELSE NULL END) AS TOTALCADASTROINADIMPLENTE
  FROM (SELECT DEB.IDDEBITO AS IDDEBITO,
               DEB.CADASTROGERAL AS CADASTROGERAL,
               REC.RECEITA AS RECEITA,
               TRIBRECEITA.DESCRICAO AS DESCRICAO,
               RECEITA.VALORRECEITA AS VALORRECEITA,
               RECEITA.VALORRENUNCIA AS VALORRENUNCIA,
               SUM(CASE WHEN SITP.TIPOSITUACAOPARCELA = 2 THEN 1 ELSE 0 END) PAGO,
               SUM(REC.VALOR) AS TOTALLANCADO, 
               SUM(CASE WHEN SITP.TIPOSITUACAOPARCELA = 2 THEN REC.VALOR ELSE 0 END) AS TOTALPAGO,
               SUM(CASE WHEN SITP.TIPOSITUACAOPARCELA = 7 THEN REC.VALOR ELSE 0 END) AS TOTALCANCELADO,
               SUM(CASE WHEN SITP.TIPOSITUACAOPARCELA NOT IN (1,2,7) THEN REC.VALOR ELSE 0 END) AS OUTRASBAIXAS,
               SUM(CASE WHEN (PAR.DATAVENCIMENTO < CURRENT_DATE) THEN REC.VALOR ELSE 0 END) AS VALORLANCADOPERIODO,
               SUM(CASE WHEN (PAR.DATAVENCIMENTO < CURRENT_DATE AND SITP.TIPOSITUACAOPARCELA = 1) THEN REC.VALOR ELSE 0 END) AS VALORINADIMPLENTE 
          FROM ${db.aise.schema}.TRIBDEBITO DEB
          LEFT OUTER JOIN ${db.aise.schema}.TRIBDEBITOPARCELA PAR ON DEB.ENTIDADE = PAR.ENTIDADE
                                               AND DEB.EXERCICIO = PAR.EXERCICIO
                                               AND DEB.TIPOCADASTRO = PAR.TIPOCADASTRO
                                               AND DEB.CADASTROGERAL = PAR.CADASTROGERAL
                                               AND DEB.GUIARECOLHIMENTO = PAR.GUIARECOLHIMENTO
                                               AND DEB.SUBDIVIDA = PAR.SUBDIVIDA
          LEFT OUTER JOIN ${db.aise.schema}.TRIBSITUACAOPARCELA SITP ON SITP.SITUACAOPARCELA = PAR.SITUACAODEBITO
          LEFT OUTER JOIN ${db.aise.schema}.TRIBDEBITORECEITA RECEITA ON RECEITA.ENTIDADE = DEB.ENTIDADE
                                                   AND RECEITA.EXERCICIO = DEB.EXERCICIO
                                                   AND RECEITA.TIPOCADASTRO = DEB.TIPOCADASTRO
                                                   AND RECEITA.CADASTROGERAL = DEB.CADASTROGERAL
                                                   AND RECEITA.GUIARECOLHIMENTO = DEB.GUIARECOLHIMENTO
                                                   AND RECEITA.SUBDIVIDA = DEB.SUBDIVIDA
          LEFT OUTER JOIN ${db.aise.schema}.TRIBDEBITOPARCELARECEITA REC ON PAR.ENTIDADE = REC.ENTIDADE
                                                      AND PAR.EXERCICIO = REC.EXERCICIO
                                                      AND PAR.TIPOCADASTRO = REC.TIPOCADASTRO
                                                      AND PAR.CADASTROGERAL = REC.CADASTROGERAL
                                                      AND PAR.GUIARECOLHIMENTO = REC.GUIARECOLHIMENTO
                                                      AND PAR.SUBDIVIDA = REC.SUBDIVIDA
                                                      AND PAR.PARCELA = REC.PARCELA
                                                      AND RECEITA.RECEITA = REC.RECEITA
          LEFT OUTER JOIN ${db.aise.schema}.TRIBRECEITA TRIBRECEITA ON TRIBRECEITA.ENTIDADE = REC.ENTIDADE
                                                   AND TRIBRECEITA.EXERCICIO = REC.EXERCICIO
                                                   AND TRIBRECEITA.RECEITA = REC.RECEITA
         WHERE DEB.ENTIDADE = :entidade
           AND DEB.EXERCICIO = :exercicio
           AND DEB.GUIARECOLHIMENTO IN (:guiasRecolhimento)
           AND REC.RECEITA IN (:receitas)
         GROUP BY DEB.IDDEBITO,
                  DEB.CADASTROGERAL,
                  REC.RECEITA,
                  RECEITA.VALORRECEITA,
                  RECEITA.VALORRENUNCIA,
                  TRIBRECEITA.DESCRICAO) T
GROUP BY RECEITA, DESCRICAO
