/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.utils;

import br.com.elotech.core.utils.NumberUtils;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SqlUtils {
    private static final String ORACLE = "ORACLE";
    private static final String H2 = "H2";
    private static final String POSTGRES = "POSTGRES";

    private SqlUtils() {
    }

    public static String toSqlLike(String str) {
        if (StringUtils.isNotEmpty((String)str)) {
            String trimed = str.trim().replaceAll("  ", " ");
            StringBuilder sqlLike = new StringBuilder().append("%").append(trimed.replace(' ', '%')).append("%");
            return sqlLike.toString();
        }
        return null;
    }

    public static String aplicaPaginacao(Pageable pageable, String sql, String platform) {
        StringBuilder query = new StringBuilder();
        if (pageable.getPageSize() > 0 && pageable.getPageNumber() > -1) {
            if (SqlUtils.isPostgres((String)platform) || SqlUtils.isH2((String)platform)) {
                query.append(sql).append(" LIMIT ").append(pageable.getPageSize()).append(" OFFSET ").append(pageable.getOffset());
            } else if (SqlUtils.isOracle((String)platform)) {
                long fim = pageable.getOffset() + (long)pageable.getPageSize();
                query.append("SELECT * FROM (SELECT R.*,ROWNUM AS RN FROM (").append(sql).append(String.format(") R WHERE ROWNUM <= %d) v WHERE V.RN > %d", fim, pageable.getOffset()));
            }
        }
        return query.toString();
    }

    public static String aplicaPaginacaoRowNumber(Pageable pageable, String sql, String rowNumberOrderBy, String platform) {
        StringBuilder query = new StringBuilder();
        if (pageable.getPageSize() > 0 && pageable.getPageNumber() > -1) {
            if (SqlUtils.isPostgres((String)platform) || SqlUtils.isH2((String)platform)) {
                return SqlUtils.aplicaPaginacao((Pageable)pageable, (String)sql, (String)platform);
            }
            if (SqlUtils.isOracle((String)platform)) {
                long inicio = pageable.getOffset() + 1L;
                long fim = inicio + (long)pageable.getPageSize() - 1L;
                query.append("SELECT * FROM (SELECT R.*,ROW_NUMBER() over(ORDER BY ").append(rowNumberOrderBy).append(") AS ROWNUMBER FROM (").append(sql).append(String.format(") R) V WHERE V.ROWNUMBER BETWEEN %d AND %d", inicio, fim));
            }
        }
        return query.toString();
    }

    public static String aplicaOrdenacao(Pageable pageable, String sql, String defaultOrderBy) {
        StringBuilder query = new StringBuilder();
        query.append(sql);
        if (pageable.getSort() != null && pageable.getSort().stream().findFirst().isPresent()) {
            String orderBy = SqlUtils.getOrderBy((Sort)pageable.getSort(), (String)defaultOrderBy);
            query.append(orderBy);
            return query.toString();
        }
        query.append(' ').append(defaultOrderBy);
        return query.toString();
    }

    private static String getOrderBy(Sort sort, String defaultOrderBy) {
        String ordenacao = sort.stream().map(ordem -> {
            String property = ordem.getProperty();
            Sort.Direction direction = ordem.getDirection();
            Boolean isValidProperty = property != null && property.matches("^([a-zA-Z]+(,)?)+(asc|desc|ASC|DESC)?$");
            if (isValidProperty.booleanValue()) {
                return property.toUpperCase(LocaleContextHolder.getLocale()) + " " + direction.toString();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.joining(", "));
        if (StringUtils.isNotBlank((String)ordenacao)) {
            return " ORDER BY " + ordenacao;
        }
        return " " + defaultOrderBy;
    }

    public static boolean isOracle(String platform) {
        return platform.toUpperCase(Locale.getDefault()).contains("ORACLE");
    }

    public static boolean isH2(String platform) {
        return platform.toUpperCase(Locale.getDefault()).contains("H2");
    }

    public static boolean isPostgres(String platform) {
        return platform.toUpperCase(Locale.getDefault()).contains("POSTGRES");
    }

    public static String like(String schema, String coluna, String filtro) {
        if (StringUtils.isBlank((String)filtro)) {
            return "";
        }
        return String.format("UPPER(%s.tiraacento(%s)) like UPPER(%s.tiraacento('%%%s%%'))", schema, coluna, schema, filtro.replace(" ", "%"));
    }

    public static String andLike(String schema, String coluna, String filtro) {
        if (StringUtils.isBlank((String)filtro)) {
            return "";
        }
        return " AND " + SqlUtils.like((String)schema, (String)coluna, (String)filtro);
    }

    public static String andEqual(String schema, String coluna, String filtro) {
        if (StringUtils.isBlank((String)filtro)) {
            return "";
        }
        return " AND" + SqlUtils.equalsTo((String)schema, (String)coluna, (String)filtro);
    }

    public static String andEqual(String coluna, Long filtro) {
        if (Objects.isNull(filtro)) {
            return "";
        }
        return String.format(" AND %s = %s ", coluna, filtro);
    }

    public static String equalsTo(String schema, String coluna, String filtro) {
        if (StringUtils.isBlank((String)filtro)) {
            return "";
        }
        return String.format(" %s.tiraacento(UPPER(%s)) = %s.tiraacento(UPPER('%s')) ", schema, coluna, schema, filtro);
    }

    public static String beginsWith(String schema, String coluna, String filtro) {
        if (StringUtils.isBlank((String)filtro)) {
            return "";
        }
        return String.format("%s.tiraacento(UPPER(%s)) like %s.tiraacento(UPPER('%s%%'))", schema, coluna, schema, filtro.replace(" ", "%"));
    }

    public static String andBeginsWith(String schema, String coluna, String filtro) {
        if (StringUtils.isBlank((String)filtro)) {
            return "";
        }
        return " AND " + SqlUtils.beginsWith((String)schema, (String)coluna, (String)filtro);
    }

    public static String regExpReplace(String source, String pattern, String replacementString, String platform) {
        String regExpression = SqlUtils.isPostgres((String)platform) ? "REGEXP_REPLACE(%s, %s, %s, 'g')" : "REGEXP_REPLACE(%s, %s, %s)";
        return String.format(regExpression, source, pattern, replacementString);
    }

    public static String andEqualNumbers(String coluna, String filtro, String platform) {
        if (Objects.isNull(filtro)) {
            return "";
        }
        return String.format(" AND %s = %s ", SqlUtils.regExpReplace((String)coluna, (String)"'\\D+'", (String)"''", (String)platform), SqlUtils.regExpReplace((String)filtro, (String)"'\\D+'", (String)"''", (String)platform));
    }

    public static String createSQLUltimaAtualizacaoByTableAndColumn(String table, String column, Long entidade) {
        String where = "";
        if (NumberUtils.isBiggerThanZero((Number)entidade).booleanValue()) {
            where = String.format(" WHERE ENTIDADE = %d", entidade);
        }
        return String.format("SELECT CASE WHEN MAX(%s) > CURRENT_DATE THEN CURRENT_DATE ELSE MAX(%s) END AS ULTIMOACESSO, '0' AS MODULO FROM %s%s", column, column, table, where);
    }

    public static String createSQLCount(String sql) {
        return "SELECT COUNT(1) TOTAL FROM (" + sql + ") T";
    }
}

