/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.saude.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.portaltransparencia.saude.domain.dto.EscalaDTO;
import br.com.elotech.portaltransparencia.saude.service.EscalaProfissionalService;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/escalas-profissionais"})
public class EscalaProfissionaisResource {
    private final EscalaProfissionalService escalaProfissionalService;

    public EscalaProfissionaisResource(EscalaProfissionalService escalaProfissionalService) {
        this.escalaProfissionalService = escalaProfissionalService;
    }

    @GetMapping
    public ResponseEntity<List<EscalaDTO>> findEstabelecimentos() {
        return ResponseEntity.ok((Object)this.escalaProfissionalService.findEstabelecimentos());
    }

    @GetMapping(value={"/{id}"})
    public void getArquivo(@PathVariable Long id, HttpServletResponse response) throws IOException {
        EscalaDTO escalaDTO = this.escalaProfissionalService.getArquivo(id);
        if (!Objects.nonNull(escalaDTO) || !Objects.nonNull(escalaDTO.getArquivo())) {
            throw RestException.notFound((String)"Arquivo n\u00e3o encontrado!");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])Base64.getDecoder().decode(escalaDTO.getArquivo()), (String)escalaDTO.getNome());
    }
}

