/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.saude.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.portaltransparencia.saude.domain.dto.AtaDTO;
import br.com.elotech.portaltransparencia.saude.domain.dto.ConselhoMunicipalDTO;
import br.com.elotech.portaltransparencia.saude.service.ConselhoService;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/conselhos"})
public class ConselhoResource {
    private final ConselhoService conselhoService;

    public ConselhoResource(ConselhoService conselhoService) {
        this.conselhoService = conselhoService;
    }

    @GetMapping(value={"/{exercicio}"})
    public ResponseEntity<List<ConselhoMunicipalDTO>> findConselhos(@PathVariable Long exercicio) {
        return ResponseEntity.ok((Object)this.conselhoService.findConselhos(exercicio));
    }

    @GetMapping(value={"/{exercicio}/{id}"})
    public ResponseEntity<List<ConselhoMunicipalDTO>> findConselho(@PathVariable Long exercicio, @PathVariable Long id) {
        return ResponseEntity.ok((Object)this.conselhoService.findConselho(id));
    }

    @GetMapping(value={"/arquivo/{id}"})
    public void getArquivo(@PathVariable Long id, HttpServletResponse response) throws IOException {
        AtaDTO ataDTO = this.conselhoService.getArquivo(id);
        if (!Objects.nonNull(ataDTO) || !Objects.nonNull(ataDTO.getArquivo())) {
            throw RestException.notFound((String)"Arquivo n\u00e3o encontrado!");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])Base64.getDecoder().decode(ataDTO.getArquivo()), (String)ataDTO.getNome());
    }
}

