/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.domain.dto;

import feign.FeignException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class FeignExceptionHandler {
    @ExceptionHandler(value={FeignException.BadRequest.class})
    public ResponseEntity<String> handleFeignException(FeignException.BadRequest exception) {
        Optional responseRaw = exception.responseBody();
        if (responseRaw.isEmpty()) {
            throw exception;
        }
        String responseText = StandardCharsets.UTF_8.decode((ByteBuffer)responseRaw.get()).toString();
        if (StringUtils.isBlank((String)responseText)) {
            throw exception;
        }
        return ResponseEntity.status((int)exception.status()).body((Object)responseText);
    }
}

