/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.license.management;

import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.license_management.context.LicenseContext;
import br.com.elotech.license_management.context.LicenseContextValues;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import java.time.LocalDate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class LicenseContextPortalTransparencia
implements LicenseContext {
    private final EntidadeContabilidadeService entidadeService;

    public LicenseContextPortalTransparencia(EntidadeContabilidadeService entidadeService) {
        this.entidadeService = entidadeService;
    }

    public LicenseContextValues getLicenseContextValues() {
        Long headerValueEntidade = ContextHolder.getHeaderValueEntidade().longValue();
        if (headerValueEntidade > 0L) {
            Entidade entidade = this.entidadeService.findOne(headerValueEntidade);
            LicenseContextValues licenseContextValues = new LicenseContextValues();
            licenseContextValues.setNomeEntidade(entidade.getNome());
            licenseContextValues.setCodigoModulo("34");
            licenseContextValues.setData(LocalDate.now());
            licenseContextValues.getUrlExclusions().add("/info");
            licenseContextValues.getUrlExclusions().add("/entidades");
            licenseContextValues.getUrlExclusions().add("/exercicios");
            licenseContextValues.getUrlExclusions().add("/parametros");
            licenseContextValues.getUrlExclusions().add("/notas-explicativa");
            licenseContextValues.getUrlExclusions().add("/configuracoes-gerais");
            licenseContextValues.getUrlExclusions().add("/contato-responsaveis");
            licenseContextValues.getUrlExclusions().add("/atendimento");
            licenseContextValues.getUrlExclusions().add("/totalacesso");
            licenseContextValues.getUrlExclusions().add("/ultimas-atualizacoes");
            return licenseContextValues;
        }
        return LicenseContextValues.builder().isExcludeAll(true).build();
    }
}

