/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.folhaportal.service;

import br.com.elotech.core.utils.Comparators;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.core.utils.StringUtils;
import br.com.elotech.folhapagamento.client.IntegracaoFolhaPortalTransparenciaClient;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaDadosServidorDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaLotacaoDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaLotacaoServidorDTO;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.EstagiarioDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.HorasExtrasDetalhesDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.PermutaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ProcessoDisciplinarDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.RegistroPontoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDadosPensaoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorResumoNaturezaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorVencimentosDescontosDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidoresHorasExtrasDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorParamsConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorResumoNaturezaDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.service.ServidorService;
import br.com.elotech.portaltransparencia.aiseportal.ws.config.ServidoresSchedule;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresCedidosRespostaResult;
import br.com.elotech.portaltransparencia.aiseportal.ws.service.ServidorServiceWS;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.folhaportal.service.VencimentoDescontoServiceOxy;
import br.com.elotech.portaltransparencia.web.rest.params.HorasExtrasDetalhesParams;
import br.com.elotech.portaltransparencia.web.rest.params.PermutaParams;
import br.com.elotech.portaltransparencia.web.rest.params.ProcessoAdministrativoParams;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorCedidoParams;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.unico.client.EntidadeFeignClient;
import br.com.elotech.unico.client.domain.EntidadeDTO;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class ServidorServiceOxy
implements ServidorService {
    private final IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient;
    private final EntidadeFeignClient entidadeClient;
    private final VencimentoDescontoServiceOxy vencimentoDescontoServiceOxy;
    private final PortalParametroService portalParametroService;
    private final ServidorServiceWS servidorWebService;
    private final BaseExport baseExport;

    public Page<ServidorDTO> loadServidores(ServidorParams params, Pageable pageable) {
        if (this.utilizaWebService()) {
            return this.getServidoresByWebService(params, pageable);
        }
        EloPage servidores = this.integracaoFolhaPortalTransparenciaClient.getServidores(ServidorParamsConverter.toDTO((ServidorParams)params), pageable);
        return new PageImpl(servidores.getContent().stream().map(ServidorDTOConverter::portalTransparenciaServidoresDTOToServidorDTO).toList(), pageable, servidores.getTotalElements());
    }

    public Page<ServidorDTO> loadAposentadosPensionistas(ServidorParams params, Pageable pageable) {
        if (this.utilizaWebService()) {
            return this.getServidoresByWebService(params, pageable);
        }
        return Page.empty((Pageable)pageable);
    }

    public List<ServidorVencimentosDescontosDTO> loadVencimentoEDescontos(ServidorParams params) {
        if (this.utilizaWebService()) {
            return this.servidorWebService.getVencimentoEDescontosWS(params);
        }
        return this.vencimentoDescontoServiceOxy.getLoadVencimentoEDescontos(params);
    }

    public List<RegistroPontoDTO> loadRegistroPonto(ServidorParams params) {
        if (this.utilizaWebService()) {
            return this.servidorWebService.getRegistroPontoWS(params);
        }
        return Collections.emptyList();
    }

    public List<String> getSituacoes(Long entidade, Long exercicio) {
        if (this.utilizaWebService()) {
            ServidorParams params = ServidorParams.builder().entidade(entidade).exercicio(exercicio).build();
            return this.servidorWebService.getServidores(params).stream().map(ServidorDTO::getSituacao).distinct().sorted().toList();
        }
        return this.integracaoFolhaPortalTransparenciaClient.findSituacoes();
    }

    public List<ServidorResumoNaturezaDTO> loadServidoresResumoNatureza(ServidorParams params) {
        if (this.utilizaWebService()) {
            return Collections.emptyList();
        }
        Long entidade = (Long)ObjectUtils.defaultIfNull((Object)params.getEntidadeAise(), (Object)params.getEntidade());
        List totalServidoresPorClasse = this.integracaoFolhaPortalTransparenciaClient.getTotalServidoresPorClasse(entidade, params.getExercicio());
        return totalServidoresPorClasse.stream().map(ServidorResumoNaturezaDTOConverter::toServidorResumoNaturezaDTO).toList();
    }

    public Optional<ServidorDadosPensaoDTO> loadPensaoServidor(ServidorParams params) {
        return Optional.empty();
    }

    public boolean utilizaWebService() {
        PortalParametroContabil parametro = this.portalParametroService.getPortalParametro(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_WEBSERVICE_MARINGA);
        return Objects.nonNull(parametro) && "1".equals(parametro.getValor());
    }

    public Boolean isIntegradoOxy() {
        return Boolean.TRUE;
    }

    public Page<ProcessoDisciplinarDTO> loadProcessosDisciplinares(ProcessoAdministrativoParams params, Pageable pageable) {
        if (!this.utilizaWebService()) {
            return Page.empty((Pageable)pageable);
        }
        List processos = this.servidorWebService.getProcessosAdministrativos(params);
        List processosForPage = processos.stream().skip((long)pageable.getPageNumber() * (long)pageable.getPageSize()).limit(pageable.getPageSize()).toList();
        return new PageImpl(processosForPage, pageable, (long)processos.size());
    }

    public List<EstagiarioDTO> loadEstagiarios(ServidorParams params, Pageable pageable) {
        if (this.utilizaWebService()) {
            return this.servidorWebService.getEstagiarios(params);
        }
        return Collections.emptyList();
    }

    public GetServidoresCedidosRespostaResult loadServidoresCedidos(ServidorCedidoParams params) {
        if (this.utilizaWebService()) {
            return this.servidorWebService.getServidoresCedidos(params);
        }
        return new GetServidoresCedidosRespostaResult();
    }

    public Optional<ServidorDTO> loadServidor(ServidorParams params) {
        if (this.utilizaWebService()) {
            return this.servidorWebService.loadServidorComDadosFinanceiros(params);
        }
        Long entidade = (Long)ObjectUtils.defaultIfNull((Object)params.getEntidadeAise(), (Object)params.getEntidade());
        return Optional.of(ServidorDTOConverter.portalTransparenciaDadosServidorDTOToServidorDTO((PortalTransparenciaDadosServidorDTO)this.integracaoFolhaPortalTransparenciaClient.getDadosServidor(entidade, params.getExercicio(), params.getMatricula())));
    }

    public Optional<ServidoresHorasExtrasDTO> loadServidoresHorasExtras(ServidorParams params) {
        if (this.utilizaWebService()) {
            return this.servidorWebService.getServidoresHorasExtras(params);
        }
        return Optional.empty();
    }

    public Page<PermutaDTO> loadPermutas(PermutaParams params, Pageable pageable) {
        if (!this.utilizaWebService()) {
            return Page.empty((Pageable)pageable);
        }
        List<PermutaDTO> permutas = this.servidorWebService.getPermutas().stream().filter(permutaDTO -> this.applyFilterPermutaByParams(permutaDTO, params)).toList();
        List permutasForPage = permutas.stream().sorted(this.getComparator(pageable, PermutaDTO.class, "dataSolicitacao")).skip((long)pageable.getPageNumber() * (long)pageable.getPageSize()).limit(pageable.getPageSize()).toList();
        return new PageImpl(permutasForPage, pageable, (long)permutas.size());
    }

    public List<HorasExtrasDetalhesDTO> loadHorasExtrasDetalhes(HorasExtrasDetalhesParams params) {
        if (this.utilizaWebService()) {
            return this.servidorWebService.getHorasExtrasDetalhes(params);
        }
        return Collections.emptyList();
    }

    public List<PortalTransparenciaLotacaoDTO> findVerbas(Long definicaoEvento, ServidorParams params) {
        return this.integracaoFolhaPortalTransparenciaClient.findLotacoes(ServidorParamsConverter.toLotacaoDTO((ServidorParams)params, (Long)definicaoEvento));
    }

    public List<PortalTransparenciaLotacaoServidorDTO> findVerbaDetalhes(Long definicaoEvento, ServidorParams params) {
        return this.integracaoFolhaPortalTransparenciaClient.findServidoresPorLotacao(ServidorParamsConverter.toLotacaoDTO((ServidorParams)params, (Long)definicaoEvento));
    }

    public String findNomeEntidadeById(Long entidadeId) {
        EntidadeDTO entidadeDTO = this.entidadeClient.findOne(entidadeId);
        return Objects.nonNull(entidadeDTO) ? entidadeDTO.getNome() : "";
    }

    public Page<EstagiarioDTO> getEstagiariosByWebService(ServidorParams params, Pageable pageable) {
        params.setEntidade(ServidoresSchedule.ENTIDADE_ESTAGIARIOS_WS_SENIOR);
        List<EstagiarioDTO> estagiarios = this.servidorWebService.getEstagiarios(params).stream().filter(estagiarioDTO -> this.applyFilterEstagiarioByParams(estagiarioDTO, params)).toList();
        if (estagiarios.isEmpty()) {
            return Page.empty((Pageable)pageable);
        }
        List estagiariosForPage = estagiarios.stream().sorted(this.getComparator(pageable, EstagiarioDTO.class, "nome")).skip((long)pageable.getPageNumber() * (long)pageable.getPageSize()).limit(pageable.getPageSize()).toList();
        return new PageImpl(estagiariosForPage, pageable, (long)estagiarios.size());
    }

    private Page<ServidorDTO> getServidoresByWebService(ServidorParams params, Pageable pageable) {
        if (this.hasFilterByCpfNotReturnedByService(params.getCpf()).booleanValue()) {
            return Page.empty((Pageable)pageable);
        }
        List<ServidorDTO> servidores = this.servidorWebService.getServidores(params).stream().filter(servidorDTO -> this.applyFilterServidorByParams(servidorDTO, params)).toList();
        if (servidores.isEmpty()) {
            return Page.empty((Pageable)pageable);
        }
        List servidoresForPage = servidores.stream().sorted(this.getComparator(pageable, ServidorDTO.class, "nome")).skip((long)pageable.getPageNumber() * (long)pageable.getPageSize()).limit(pageable.getPageSize()).toList();
        return new PageImpl(servidoresForPage, pageable, (long)servidores.size());
    }

    private Boolean applyFilterPermutaByParams(PermutaDTO permuta, PermutaParams params) {
        return this.applyFilterIfExists(params.getNomeServidor(), permuta.getNome()) != false && this.applyFilterIfExists(params.getCargo(), permuta.getCargo()) != false && this.applyFilterIfExists(params.getLocalDe(), permuta.getLotacaoAtual()) != false && this.applyFilterIfExists(params.getLocalPara(), permuta.getLotacaoDesejada()) != false;
    }

    private Boolean applyFilterServidorByParams(ServidorDTO servidor, ServidorParams params) {
        return this.applyFilterBySalario(params, servidor.getSalarioBase()) != false && this.applyFilterIfExists(params.getNomeServidor(), servidor.getNome()) != false && this.applyFilterIfExists(params.getSituacao(), servidor.getSituacao()) != false && this.applyFilterIfExists(params.getCargo(), servidor.getDescricaoCargo()) != false && this.applyFilterIfExists(params.getLotacao(), servidor.getDescricaoLotacao()) != false && this.applyFilterIfExists(params.getDescricaoNatureza(), servidor.getDescricaoNatureza()) != false && this.applyFilterIfExists(params.getVinculo(), servidor.getVinculo()) != false;
    }

    private boolean applyFilterEstagiarioByParams(EstagiarioDTO estagiario, ServidorParams params) {
        return this.applyFilterIfExists(params.getNomeServidor(), estagiario.getNome()) != false && this.applyFilterIfExists(params.getSituacao(), estagiario.getSituacao()) != false && this.applyFilterIfExists(params.getCargo(), estagiario.getDescricaoCargo()) != false && this.applyFilterIfExists(params.getLotacao(), estagiario.getDescricaoLotacao()) != false && this.applyFilterIfExists(params.getDescricaoNatureza(), estagiario.getDescricaoNatureza()) != false && this.applyFilterIfExists(params.getVinculo(), estagiario.getVinculo()) != false;
    }

    private Boolean applyFilterIfExists(String filterValue, String fieldValue) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)filterValue)) {
            return true;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)fieldValue)) {
            return false;
        }
        return StringUtils.retiraAcentos((String)fieldValue.toUpperCase(Locale.getDefault())).contains(StringUtils.retiraAcentos((String)filterValue.toUpperCase(Locale.getDefault())));
    }

    private Boolean applyFilterBySalario(ServidorParams params, BigDecimal valorSalarioBase) {
        if (Objects.isNull(params.getValorSalarioInicial()) && Objects.isNull(params.getValorSalarioFinal())) {
            return Boolean.TRUE;
        }
        if (Objects.isNull(valorSalarioBase)) {
            return Boolean.FALSE;
        }
        return !(!Objects.isNull(params.getValorSalarioInicial()) && params.getValorSalarioInicial().compareTo(valorSalarioBase) > 0 || !Objects.isNull(params.getValorSalarioFinal()) && params.getValorSalarioFinal().compareTo(valorSalarioBase) < 0);
    }

    private Boolean hasFilterByCpfNotReturnedByService(String paramCpf) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)paramCpf);
    }

    private <T> Comparator<T> getComparator(Pageable pageable, Class<T> classType, String defaultField) {
        return pageable.getSort().stream().map(order -> {
            Comparator comparator = Comparators.comparingField((Class)classType, (String)order.getProperty());
            return order.isDescending() ? comparator.reversed() : comparator;
        }).reduce(Comparator::thenComparing).orElse(Comparators.comparingField(classType, (String)defaultField));
    }

    @Generated
    public ServidorServiceOxy(IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient, EntidadeFeignClient entidadeClient, VencimentoDescontoServiceOxy vencimentoDescontoServiceOxy, PortalParametroService portalParametroService, ServidorServiceWS servidorWebService, BaseExport baseExport) {
        this.integracaoFolhaPortalTransparenciaClient = integracaoFolhaPortalTransparenciaClient;
        this.entidadeClient = entidadeClient;
        this.vencimentoDescontoServiceOxy = vencimentoDescontoServiceOxy;
        this.portalParametroService = portalParametroService;
        this.servidorWebService = servidorWebService;
        this.baseExport = baseExport;
    }

    @Generated
    public BaseExport getBaseExport() {
        return this.baseExport;
    }
}

