/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.portaltransparencia.contabportal.domain.CartaServicos;
import br.com.elotech.portaltransparencia.contabportal.domain.CartaServicosPK;
import br.com.elotech.portaltransparencia.contabportal.repository.CartaServicosRepository;
import br.com.elotech.portaltransparencia.contabportal.service.CartaServicosService;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class CartaServicosServiceImpl
extends ReadOnlyService<CartaServicos, CartaServicosPK>
implements CartaServicosService {
    private final CartaServicosRepository cartaServicosRepository;

    @Autowired
    public CartaServicosServiceImpl(CartaServicosRepository cartaServicosRepository) {
        this.cartaServicosRepository = cartaServicosRepository;
    }

    public List<CartaServicos> findByEntidadeAndFiltro(Long idEntidade, String filtro) {
        List cartaServicosByEntidade = this.cartaServicosRepository.findByIdEntidadeIdAndAtivoTrue(idEntidade);
        if (StringUtils.isNotBlank((String)filtro)) {
            return cartaServicosByEntidade.stream().filter(p -> br.com.elotech.core.utils.StringUtils.simplify((String)p.getTitulo()).contains(br.com.elotech.core.utils.StringUtils.simplify((String)filtro)) || br.com.elotech.core.utils.StringUtils.simplify((String)p.getDescricao()).contains(br.com.elotech.core.utils.StringUtils.simplify((String)filtro))).collect(Collectors.toList());
        }
        return cartaServicosByEntidade;
    }

    public Page<CartaServicos> findByEntidade(Long idEntidade, Pageable page) {
        return this.cartaServicosRepository.findByIdEntidadeId(idEntidade, page);
    }

    @Transactional
    public CartaServicos save(CartaServicos pergunta) {
        return (CartaServicos)this.cartaServicosRepository.save((Object)pergunta);
    }

    @Transactional
    public void remove(CartaServicos pergunta) {
        this.cartaServicosRepository.delete((Object)pergunta);
    }
}

