/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalOrganograma;
import br.com.elotech.portaltransparencia.contabportal.repository.PortalOrganogramaRepository;
import br.com.elotech.portaltransparencia.rsql.CustomRsqlUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class PortalOrganogramaService {
    private final PortalOrganogramaRepository portalOrganogramaRepository;
    private final ArquivoService arquivoService;
    private final EntityManager em;
    private final DBConfigProperties dbConfigProperties;

    @Autowired
    public PortalOrganogramaService(PortalOrganogramaRepository portalOrganogramaRepository, EntityManager em, ArquivoService arquivoService, DBConfigProperties dbConfigProperties) {
        this.portalOrganogramaRepository = portalOrganogramaRepository;
        this.em = em;
        this.arquivoService = arquivoService;
        this.dbConfigProperties = dbConfigProperties;
    }

    public List<PortalOrganograma> getOrganograma(Long entidade) {
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"ordem"});
        String search = String.format("entidade==%d", entidade);
        Specification specification = Specification.where((Specification)CustomRsqlUtils.createSpecFrom((EntityManager)this.em, (String)search, (String)this.dbConfigProperties.getContabilidade().getSchema()));
        ArrayList list = Lists.newArrayList((Iterable)this.portalOrganogramaRepository.findAll(specification, sort));
        for (PortalOrganograma portalOrganograma : list) {
            if (Objects.nonNull(portalOrganograma.getResumo())) {
                portalOrganograma.setResumo(portalOrganograma.getResumo().replaceAll("(\\r\\n|\\n)", "<br />"));
            }
            if (!Objects.nonNull(portalOrganograma.getArquivo()) || !Objects.nonNull(portalOrganograma.getArquivo().getEloArquivo().getId())) continue;
            portalOrganograma.getArquivo().setTamanhoArquivo(this.arquivoService.getTamanhoArquivo(portalOrganograma.getArquivo().getEloArquivo().getId()));
        }
        return list;
    }
}

