/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ConsumoPorCentroCustroDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ItemEstoqueDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.OrgaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.ItemEstoqueRepository;
import br.com.elotech.portaltransparencia.web.rest.params.ConsumoPorCentroCustoParams;
import br.com.elotech.portaltransparencia.web.rest.params.ItemEstoqueParams;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ItemEstoqueService {
    private final ItemEstoqueRepository itemEstoqueRepository;

    public ItemEstoqueService(ItemEstoqueRepository itemEstoqueRepository) {
        this.itemEstoqueRepository = itemEstoqueRepository;
    }

    public Page<ItemEstoqueDTO> findItemEstoque(ItemEstoqueParams params, Pageable pageable) {
        return this.itemEstoqueRepository.findItemEstoque(params, pageable);
    }

    public Page<ConsumoPorCentroCustroDTO> findItensConsumo(ConsumoPorCentroCustoParams params, Pageable pageable) {
        return this.itemEstoqueRepository.findItensConsumo(params, pageable);
    }

    public List<OrgaoDTO> findOrgao(FindExercicioParams params) {
        return this.itemEstoqueRepository.findOrgao(params).stream().sorted(Comparator.comparingLong(arg_0 -> this.getOrgao(arg_0))).collect(Collectors.toList());
    }

    private Long getOrgao(OrgaoDTO orgaoDTO) {
        try {
            return Long.parseLong(orgaoDTO.getOrgao());
        }
        catch (NumberFormatException ex) {
            return 0L;
        }
    }

    public List<UltimaAtualizacaoDTO> findUltimaAtualizacao(FindExercicioParams params) {
        return this.itemEstoqueRepository.findUltimaAtualizacao(params);
    }

    public BigDecimal findTotalConsumido(ConsumoPorCentroCustoParams params) {
        return this.itemEstoqueRepository.findTotalConsumido(params);
    }
}

